/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.test.junit5;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class DmnEngineExtension
implements TestInstancePostProcessor,
BeforeTestExecutionCallback,
ParameterResolver {
    protected final DmnEngineConfiguration dmnEngineConfiguration;
    protected DmnEngine dmnEngine;

    public DmnEngineExtension() {
        this.dmnEngineConfiguration = DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
    }

    public static DmnEngineExtension forConfiguration(DmnEngineConfiguration configuration) {
        return new DmnEngineExtension(Objects.requireNonNull(configuration, "configuration must not be null"));
    }

    protected DmnEngineExtension(DmnEngineConfiguration configuration) {
        this.dmnEngineConfiguration = configuration;
    }

    protected void initializeDmnEngine() {
        if (this.dmnEngine == null) {
            this.dmnEngine = this.dmnEngineConfiguration.buildEngine();
        }
    }

    protected void injectDmnEngine(Object instance, Field field) {
        field.setAccessible(true);
        try {
            field.set(instance, this.dmnEngine);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.injectIntoTestInstance(testInstance);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        Optional testInstance = context.getTestInstance();
        if (testInstance.isPresent()) {
            this.injectIntoTestInstance(testInstance.get());
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return DmnEngine.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (!DmnEngine.class.equals(parameterContext.getParameter().getType())) {
            return null;
        }
        this.initializeDmnEngine();
        return this.dmnEngine;
    }

    private void injectIntoTestInstance(Object testInstance) throws Exception {
        this.initializeDmnEngine();
        Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> DmnEngine.class.equals(field.getType())).forEach(field -> this.injectDmnEngine(testInstance, (Field)field));
    }
}

