/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.hitpolicy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedDecisionRule;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedOutput;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.delegate.DmnDecisionTableEvaluationEventImpl;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.DmnHitPolicyLogger;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.HitPolicyEntry;
import org.camunda.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandler;
import org.camunda.bpm.model.dmn.HitPolicy;

public class AnyHitPolicyHandler
implements DmnHitPolicyHandler {
    public static final DmnHitPolicyLogger LOG = DmnLogger.HIT_POLICY_LOGGER;
    protected static final HitPolicyEntry HIT_POLICY = new HitPolicyEntry(HitPolicy.ANY, null);

    @Override
    public HitPolicyEntry getHitPolicyEntry() {
        return HIT_POLICY;
    }

    @Override
    public DmnDecisionTableEvaluationEvent apply(DmnDecisionTableEvaluationEvent decisionTableEvaluationEvent) {
        List<DmnEvaluatedDecisionRule> matchingRules = decisionTableEvaluationEvent.getMatchingRules();
        if (!matchingRules.isEmpty()) {
            if (this.allOutputsAreEqual(matchingRules)) {
                DmnEvaluatedDecisionRule firstMatchingRule = matchingRules.get(0);
                ((DmnDecisionTableEvaluationEventImpl)decisionTableEvaluationEvent).setMatchingRules(Collections.singletonList(firstMatchingRule));
            } else {
                throw LOG.anyHitPolicyRequiresThatAllOutputsAreEqual(matchingRules);
            }
        }
        return decisionTableEvaluationEvent;
    }

    protected boolean allOutputsAreEqual(List<DmnEvaluatedDecisionRule> matchingRules) {
        Map<String, DmnEvaluatedOutput> firstOutputEntries = matchingRules.get(0).getOutputEntries();
        if (firstOutputEntries == null) {
            for (int i = 1; i < matchingRules.size(); ++i) {
                if (matchingRules.get(i).getOutputEntries() == null) continue;
                return false;
            }
        } else {
            for (int i = 1; i < matchingRules.size(); ++i) {
                if (firstOutputEntries.equals(matchingRules.get(i).getOutputEntries())) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "AnyHitPolicyHandler{}";
    }
}

