/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionModel;
import org.camunda.bpm.dmn.engine.DmnItemDefinition;
import org.camunda.bpm.dmn.engine.impl.DmnElementImpl;

public class DmnDecisionModelImpl
extends DmnElementImpl
implements DmnDecisionModel {
    protected String expressionLanguage = "juel";
    protected String typeLanguage;
    protected String namespace;
    protected Map<String, DmnItemDefinition> itemDefinitions = new HashMap<String, DmnItemDefinition>();
    protected Map<String, DmnDecision> decisions = new HashMap<String, DmnDecision>();

    @Override
    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public String getTypeLanguage() {
        return this.typeLanguage;
    }

    public void setTypeLanguage(String typeLanguage) {
        this.typeLanguage = typeLanguage;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public List<DmnItemDefinition> getItemDefinitions() {
        return new ArrayList<DmnItemDefinition>(this.itemDefinitions.values());
    }

    public void setItemDefinitions(Collection<DmnItemDefinition> itemDefinitions) {
        this.itemDefinitions.clear();
        for (DmnItemDefinition itemDefinition : itemDefinitions) {
            this.addItemDefinition(itemDefinition);
        }
    }

    public void addItemDefinition(DmnItemDefinition itemDefinition) {
        this.itemDefinitions.put(itemDefinition.getKey(), itemDefinition);
    }

    @Override
    public DmnItemDefinition getItemDefinition(String itemDefinitionKey) {
        return this.itemDefinitions.get(itemDefinitionKey);
    }

    @Override
    public <T extends DmnDecision> List<T> getDecisions() {
        return new ArrayList<DmnDecision>(this.decisions.values());
    }

    @Override
    public <T extends DmnDecision> T getDecision(String decisionKey) {
        return (T)this.decisions.get(decisionKey);
    }

    public void setDecisions(Collection<DmnDecision> decisions) {
        this.decisions.clear();
        for (DmnDecision decision : decisions) {
            this.addDecision(decision);
        }
    }

    public void addDecision(DmnDecision decision) {
        this.decisions.put(decision.getKey(), decision);
    }

    @Override
    public String toString() {
        return "DmnDecisionModelImpl{key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", expressionLanguage='" + this.expressionLanguage + '\'' + ", typeLanguage='" + this.typeLanguage + '\'' + ", namespace='" + this.namespace + '\'' + ", itemDefinitions=" + this.itemDefinitions + ", decisions=" + this.decisions + '}';
    }
}

