/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTableListener;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.DmnEngineMetricCollector;
import org.camunda.bpm.dmn.engine.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.context.DmnContextFactory;
import org.camunda.bpm.dmn.engine.handler.DmnElementHandlerRegistry;
import org.camunda.bpm.dmn.engine.hitpolicy.DmnHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.DefaultScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.DmnEngineImpl;
import org.camunda.bpm.dmn.engine.impl.DmnEngineMetricCollectorImpl;
import org.camunda.bpm.dmn.engine.impl.context.DmnContextFactoryImpl;
import org.camunda.bpm.dmn.engine.impl.handler.DmnElementHandlerRegistryImpl;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.AnyHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.FirstHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.OutputOrderHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.PriorityHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.RuleOrderHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.UniqueHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.transform.DmnTransformFactoryImpl;
import org.camunda.bpm.dmn.engine.impl.transform.DmnTransformerImpl;
import org.camunda.bpm.dmn.engine.impl.type.DefaultDataTypeTransformerFactory;
import org.camunda.bpm.dmn.engine.transform.DmnTransformFactory;
import org.camunda.bpm.dmn.engine.transform.DmnTransformListener;
import org.camunda.bpm.dmn.engine.transform.DmnTransformer;
import org.camunda.bpm.dmn.engine.type.DataTypeTransformerFactory;
import org.camunda.bpm.model.dmn.HitPolicy;

public class DmnEngineConfigurationImpl
implements DmnEngineConfiguration {
    protected DmnContextFactory contextFactory;
    protected DmnTransformer transformer;
    protected DmnTransformFactory transformFactory;
    protected DmnElementHandlerRegistry elementHandlerRegistry;
    protected DmnEngineMetricCollector engineMetricCollector;
    protected List<DmnTransformListener> customPreDmnTransformListeners = new ArrayList<DmnTransformListener>();
    protected List<DmnTransformListener> customPostDmnTransformListeners = new ArrayList<DmnTransformListener>();
    protected List<DmnDecisionTableListener> customPreDmnDecisionTableListeners = new ArrayList<DmnDecisionTableListener>();
    protected List<DmnDecisionTableListener> customDmnDecisionTableListeners = new ArrayList<DmnDecisionTableListener>();
    protected List<DmnDecisionTableListener> customPostDmnDecisionTableListeners = new ArrayList<DmnDecisionTableListener>();
    protected Map<HitPolicy, DmnHitPolicyHandler> hitPolicyHandlers;
    protected DmnScriptEngineResolver scriptEngineResolver;
    protected DataTypeTransformerFactory dataTypeTransformerFactory;

    @Override
    public DmnContextFactory getDmnContextFactory() {
        return this.contextFactory;
    }

    public void setDmnContextFactory(DmnContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public DmnTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public DmnTransformFactory getTransformFactory() {
        return this.transformFactory;
    }

    public void setTransformFactory(DmnTransformFactory transformFactory) {
        this.transformFactory = transformFactory;
    }

    @Override
    public DmnElementHandlerRegistry getElementHandlerRegistry() {
        return this.elementHandlerRegistry;
    }

    public void setElementHandlerRegistry(DmnElementHandlerRegistry elementHandlerRegistry) {
        this.elementHandlerRegistry = elementHandlerRegistry;
    }

    @Override
    public DmnEngineMetricCollector getEngineMetricCollector() {
        return this.engineMetricCollector;
    }

    public void setEngineMetricCollector(DmnEngineMetricCollector engineMetricCollector) {
        this.engineMetricCollector = engineMetricCollector;
    }

    @Override
    public List<DmnTransformListener> getCustomPreDmnTransformListeners() {
        return this.customPreDmnTransformListeners;
    }

    public void setCustomPreDmnTransformListeners(List<DmnTransformListener> customPreDmnTransformListeners) {
        this.customPreDmnTransformListeners = customPreDmnTransformListeners;
    }

    @Override
    public List<DmnTransformListener> getCustomPostDmnTransformListeners() {
        return this.customPostDmnTransformListeners;
    }

    public void setCustomPostDmnTransformListeners(List<DmnTransformListener> customPostDmnTransformListeners) {
        this.customPostDmnTransformListeners = customPostDmnTransformListeners;
    }

    @Override
    public List<DmnDecisionTableListener> getCustomPreDmnDecisionTableListeners() {
        return this.customPreDmnDecisionTableListeners;
    }

    @Override
    public List<DmnDecisionTableListener> getCustomDmnDecisionTableListeners() {
        return this.customDmnDecisionTableListeners;
    }

    public void setCustomPreDmnDecisionTableListeners(List<DmnDecisionTableListener> customPreDmnDecisionTableListeners) {
        this.customPreDmnDecisionTableListeners = customPreDmnDecisionTableListeners;
    }

    public void setCustomDmnDecisionTableListeners(List<DmnDecisionTableListener> customDmnDecisionTableListeners) {
        this.customDmnDecisionTableListeners = customDmnDecisionTableListeners;
    }

    @Override
    public List<DmnDecisionTableListener> getCustomPostDmnDecisionTableListeners() {
        return this.customPostDmnDecisionTableListeners;
    }

    public void setCustomPostDmnDecisionTableListeners(List<DmnDecisionTableListener> customPostDmnDecisionTableListeners) {
        this.customPostDmnDecisionTableListeners = customPostDmnDecisionTableListeners;
    }

    @Override
    public Map<HitPolicy, DmnHitPolicyHandler> getHitPolicyHandlers() {
        return this.hitPolicyHandlers;
    }

    public void setHitPolicyHandlers(Map<HitPolicy, DmnHitPolicyHandler> hitPolicyHandlers) {
        this.hitPolicyHandlers = hitPolicyHandlers;
    }

    @Override
    public DmnScriptEngineResolver getScriptEngineResolver() {
        return this.scriptEngineResolver;
    }

    public void setScriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.scriptEngineResolver = scriptEngineResolver;
    }

    @Override
    public DataTypeTransformerFactory getDataTypeTransformerFactory() {
        return this.dataTypeTransformerFactory;
    }

    public void setDataTypeTransformerFactory(DataTypeTransformerFactory dataTypeTransformerFactory) {
        this.dataTypeTransformerFactory = dataTypeTransformerFactory;
    }

    @Override
    public DmnEngine buildEngine() {
        this.init();
        return new DmnEngineImpl(this);
    }

    protected void init() {
        this.initContextFactory();
        this.initTransformFactory();
        this.initElementHandlerRegistry();
        this.initMetricCollector();
        this.initDataTypeTransformerFactory();
        this.initTransformer();
        this.initDmnDecisionTableListeners();
        this.initHitPolicyHandlers();
        this.initScriptEngineResolver();
    }

    protected void initContextFactory() {
        if (this.contextFactory == null) {
            this.contextFactory = new DmnContextFactoryImpl();
        }
    }

    public void initTransformFactory() {
        if (this.transformFactory == null) {
            this.transformFactory = new DmnTransformFactoryImpl();
        }
    }

    protected void initElementHandlerRegistry() {
        if (this.elementHandlerRegistry == null) {
            this.elementHandlerRegistry = new DmnElementHandlerRegistryImpl();
        }
    }

    protected void initMetricCollector() {
        if (this.engineMetricCollector == null) {
            this.engineMetricCollector = new DmnEngineMetricCollectorImpl();
        }
    }

    protected void initTransformer() {
        this.transformer = new DmnTransformerImpl(this.transformFactory, this.elementHandlerRegistry, this.dataTypeTransformerFactory);
        if (this.customPreDmnTransformListeners != null) {
            this.transformer.getTransformListeners().addAll(this.customPreDmnTransformListeners);
        }
        this.transformer.getTransformListeners().addAll(this.getDefaultDmnTransformListeners());
        if (this.customPostDmnTransformListeners != null) {
            this.transformer.getTransformListeners().addAll(this.customPostDmnTransformListeners);
        }
    }

    protected List<DmnTransformListener> getDefaultDmnTransformListeners() {
        return Collections.emptyList();
    }

    protected void initDmnDecisionTableListeners() {
        ArrayList<DmnDecisionTableListener> listeners = new ArrayList<DmnDecisionTableListener>();
        if (this.customPreDmnDecisionTableListeners != null) {
            listeners.addAll(this.customPreDmnDecisionTableListeners);
        }
        listeners.addAll(this.getDefaultDmnDecisionTableListeners());
        if (this.customPostDmnDecisionTableListeners != null) {
            listeners.addAll(this.customPostDmnDecisionTableListeners);
        }
        this.setCustomDmnDecisionTableListeners(listeners);
    }

    protected List<DmnDecisionTableListener> getDefaultDmnDecisionTableListeners() {
        ArrayList<DmnDecisionTableListener> defaultListeners = new ArrayList<DmnDecisionTableListener>();
        defaultListeners.add(this.engineMetricCollector);
        return defaultListeners;
    }

    protected void initHitPolicyHandlers() {
        if (this.hitPolicyHandlers == null) {
            this.hitPolicyHandlers = this.getDefaultHitPolicyHandlers();
        }
    }

    protected Map<HitPolicy, DmnHitPolicyHandler> getDefaultHitPolicyHandlers() {
        HashMap<HitPolicy, DmnHitPolicyHandler> hitPolicyHandlers = new HashMap<HitPolicy, DmnHitPolicyHandler>();
        hitPolicyHandlers.put(HitPolicy.UNIQUE, new UniqueHitPolicyHandler());
        hitPolicyHandlers.put(HitPolicy.ANY, new AnyHitPolicyHandler());
        hitPolicyHandlers.put(HitPolicy.PRIORITY, new PriorityHitPolicyHandler());
        hitPolicyHandlers.put(HitPolicy.FIRST, new FirstHitPolicyHandler());
        hitPolicyHandlers.put(HitPolicy.OUTPUT_ORDER, new OutputOrderHitPolicyHandler());
        hitPolicyHandlers.put(HitPolicy.RULE_ORDER, new RuleOrderHitPolicyHandler());
        hitPolicyHandlers.put(HitPolicy.COLLECT, new CollectHitPolicyHandler());
        return hitPolicyHandlers;
    }

    protected void initScriptEngineResolver() {
        if (this.scriptEngineResolver == null) {
            this.scriptEngineResolver = new DefaultScriptEngineResolver();
        }
    }

    protected void initDataTypeTransformerFactory() {
        if (this.dataTypeTransformerFactory == null) {
            this.dataTypeTransformerFactory = new DefaultDataTypeTransformerFactory();
        }
    }
}

