/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionModel;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.context.DmnContextFactory;
import org.camunda.bpm.dmn.engine.context.DmnDecisionContext;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.transform.DmnTransformer;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.commons.utils.IoUtil;
import org.camunda.commons.utils.IoUtilException;

public class DmnEngineImpl
implements DmnEngine {
    protected static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected DmnEngineConfiguration configuration;
    protected DmnTransformer transformer;
    protected DmnContextFactory contextFactory;

    public DmnEngineImpl(DmnEngineConfiguration configuration) {
        this.configuration = configuration;
        this.transformer = configuration.getTransformer();
        this.contextFactory = configuration.getDmnContextFactory();
    }

    @Override
    public DmnEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public DmnDecisionModel parseDecisionModel(String filename) {
        try {
            InputStream inputStream = IoUtil.fileAsStream((String)filename);
            return this.parseDecisionModel(inputStream);
        }
        catch (IoUtilException e) {
            throw LOG.unableToReadFile(filename, e);
        }
    }

    @Override
    public DmnDecisionModel parseDecisionModel(InputStream inputStream) {
        try {
            return this.transformer.createTransform().setModelInstance(inputStream).transform();
        }
        catch (DmnModelException e) {
            throw LOG.unableToReadInputStream(e);
        }
    }

    @Override
    public DmnDecisionModel parseDecisionModel(DmnModelInstance modelInstance) {
        return this.transformer.createTransform().setModelInstance(modelInstance).transform();
    }

    @Override
    public DmnDecision parseDecision(String filename) {
        List decisions = this.parseDecisionModel(filename).getDecisions();
        if (!decisions.isEmpty()) {
            return (DmnDecision)decisions.get(0);
        }
        throw LOG.unableToFindAnyDecisionInFile(filename);
    }

    @Override
    public DmnDecision parseDecision(InputStream inputStream) {
        List decisions = this.parseDecisionModel(inputStream).getDecisions();
        if (!decisions.isEmpty()) {
            return (DmnDecision)decisions.get(0);
        }
        throw LOG.unableToFindAnyDecision();
    }

    @Override
    public DmnDecision parseDecision(DmnModelInstance modelInstance) {
        List decisions = this.parseDecisionModel(modelInstance).getDecisions();
        if (!decisions.isEmpty()) {
            return (DmnDecision)decisions.get(0);
        }
        throw LOG.unableToFindAnyDecision();
    }

    @Override
    public DmnDecision parseDecision(String filename, String decisionKey) {
        Object decision = this.parseDecisionModel(filename).getDecision(decisionKey);
        if (decision != null) {
            return decision;
        }
        throw LOG.unableToFinDecisionWithKeyInFile(filename, decisionKey);
    }

    @Override
    public DmnDecision parseDecision(InputStream inputStream, String decisionKey) {
        Object decision = this.parseDecisionModel(inputStream).getDecision(decisionKey);
        if (decision != null) {
            return decision;
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }

    @Override
    public DmnDecision parseDecision(DmnModelInstance modelInstance, String decisionKey) {
        Object decision = this.parseDecisionModel(modelInstance).getDecision(decisionKey);
        if (decision != null) {
            return decision;
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }

    @Override
    public DmnDecisionResult evaluate(DmnDecision decision, Map<String, Object> variables) {
        DmnDecisionContext decisionContext = this.contextFactory.createDecisionContext(this.configuration);
        return decisionContext.evaluateDecision(decision, variables);
    }

    @Override
    public DmnDecisionResult evaluate(DmnDecisionModel decisionModel, Map<String, Object> variables) {
        DmnDecision decision = (DmnDecision)decisionModel.getDecisions().get(0);
        return this.evaluate(decision, variables);
    }

    @Override
    public DmnDecisionResult evaluate(DmnDecisionModel decisionModel, String decisionKey, Map<String, Object> variables) {
        Object decision = decisionModel.getDecision(decisionKey);
        return this.evaluate((DmnDecision)decision, variables);
    }
}

