/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnEngineException;
import org.camunda.bpm.dmn.engine.DmnExpressionException;
import org.camunda.bpm.dmn.engine.DmnTransformException;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.model.dmn.HitPolicy;

public class DmnEngineLogger
extends DmnLogger {
    public DmnEngineException outputDoesNotContainAnyComponent() {
        return new DmnEngineException(this.exceptionMessage("001", "The DMN output doesn't contain any component.", new Object[0]));
    }

    public DmnEngineException unableToFindOutputComponentWithName(String name) {
        return new DmnEngineException(this.exceptionMessage("002", "Unable to find output component with name '{}'.", new Object[]{name}));
    }

    public DmnEngineException notConfigurationSetInContext() {
        return new DmnEngineException(this.exceptionMessage("003", "No engine configuration set in decision context", new Object[0]));
    }

    public DmnEngineException noScriptContextSetInDecisionContext() {
        return new DmnEngineException(this.exceptionMessage("004", "No script context set in decision context", new Object[0]));
    }

    public DmnEngineException unableToFindScriptEngineForName(String name) {
        return new DmnEngineException(this.exceptionMessage("005", "Unable to find script engine for name '{}'.", new Object[]{name}));
    }

    public DmnTransformException unableToReadFile(String filename, Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("006", "Unable to read model from file '{}'.", new Object[]{filename}), cause);
    }

    public DmnTransformException unableToReadInputStream(Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("007", "Unable to read model from input stream.", new Object[0]), cause);
    }

    public DmnTransformException unableToFinDecisionWithKeyInFile(String filename, String decisionKey) {
        return new DmnTransformException(this.exceptionMessage("008", "Unable to find decision with id '{}' in file '{}'.", new Object[]{decisionKey, filename}));
    }

    public DmnTransformException unableToFindDecisionWithKey(String decisionKey) {
        return new DmnTransformException(this.exceptionMessage("009", "Unable to find decision with id '{}' in model.", new Object[]{decisionKey}));
    }

    public DmnTransformException unableToFindAnyDecisionInFile(String filename) {
        return new DmnTransformException(this.exceptionMessage("010", "Unable to find any decision in file '{}'.", new Object[]{filename}));
    }

    public DmnTransformException unableToFindAnyDecision() {
        return new DmnTransformException(this.exceptionMessage("011", "Unable to find any decision in model.", new Object[0]));
    }

    public DmnEngineException noVariableContextSetInDecisionContext() {
        return new DmnEngineException(this.exceptionMessage("012", "No variable context set in decision context", new Object[0]));
    }

    public DmnExpressionException unableToEvaluateExpression(String expression, String expressionLanguage, Throwable cause) {
        return new DmnExpressionException(this.exceptionMessage("013", "Unable to evaluate expression for language '{}': '{}'", new Object[]{expressionLanguage, expression}), cause);
    }

    public DmnExpressionException unableToCastExpressionResult(Object result, Throwable cause) {
        return new DmnExpressionException(this.exceptionMessage("014", "Unable to cast result '{}' to expected type", new Object[]{result}), cause);
    }

    public DmnExpressionException noScriptEngineFoundForLanguage(String expressionLanguage, String defaultExpressionLanguage) {
        if (expressionLanguage != null) {
            return new DmnExpressionException(this.exceptionMessage("015", "Unable to find script engine for expression language '{}'.", new Object[]{expressionLanguage}));
        }
        return new DmnExpressionException(this.exceptionMessage("015", "Unable to find script engine for default expression language '{}'.", new Object[]{defaultExpressionLanguage}));
    }

    public DmnEngineException decisionTypeNotSupported(DmnDecision decision) {
        return new DmnEngineException(this.exceptionMessage("016", "Decision type '{}' not supported by DMN engine.", new Object[]{decision.getClass()}));
    }

    public DmnEngineException unableToFindHitPolicyHandlerFor(HitPolicy hitPolicy) {
        return new DmnEngineException(this.exceptionMessage("017", "Unable to find handler for hit policy '{}'.", new Object[]{hitPolicy}));
    }

    public DmnEngineException invalidOutputValue(String typeName, Object value) {
        return new DmnEngineException(this.exceptionMessage("018", "Invalid value '{}' for output clause with type '{}'.", new Object[]{value, typeName}));
    }

    public void unsupportedOutputDefinitionType(String typeName) {
        this.logWarn("019", "Unsupported type '{}' for output clause. Values of this clause will not transform into another type.", new Object[]{typeName});
    }
}

