/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.io.File;
import org.camunda.bpm.dmn.engine.DmnTransformException;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.model.dmn.instance.Clause;
import org.camunda.bpm.model.dmn.instance.Decision;

public class DmnTransformLogger
extends DmnLogger {
    public DmnTransformException unableToFindDecision(String decisionKey, String filename) {
        String id = "001";
        String message = decisionKey != null && !decisionKey.isEmpty() && filename != null ? this.exceptionMessage(id, "Unable to find decision '{}' in DMN model '{}'.", new Object[]{decisionKey, filename}) : (decisionKey != null && !decisionKey.isEmpty() ? this.exceptionMessage(id, "Unable to find decision '{}' in DMN model.", new Object[]{decisionKey}) : (filename != null ? this.exceptionMessage(id, "Unable to find decision in DMN model '{}'.", new Object[]{filename}) : this.exceptionMessage(id, "Unable to find decision in DMN model.", new Object[0])));
        return new DmnTransformException(message);
    }

    public void decisionTypeNotSupported(Decision decision) {
        this.logInfo("002", "The expression type '{}' of the decision '{}' is not supported.", new Object[]{decision.getClass().getSimpleName(), decision.getId()});
    }

    public DmnTransformException unableToTransformDecisionFromFile(String filename, String decisionKey, Throwable cause) {
        String id = "003";
        if (decisionKey != null && !decisionKey.isEmpty()) {
            return new DmnTransformException(this.exceptionMessage(id, "Unable to transform decision '{}' from file '{}'.", new Object[]{decisionKey, filename}), cause);
        }
        return new DmnTransformException(this.exceptionMessage(id, "Unable to transform decision from file '{}'.", new Object[]{filename}), cause);
    }

    public void ignoringClause(Clause clause) {
        this.logInfo("004", "Ignoring clause '{}' as neither an input expression nor output definition was found.", new Object[]{clause.getId()});
    }

    public DmnTransformException unableToTransformModelFromFile(File file, Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("005", "Unable to transform decision model from file '{}'.", new Object[]{file.getAbsolutePath()}), cause);
    }

    public DmnTransformException unableToTransformModelFromInputStream(Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("006", "Unable to transform decision model from input stream.", new Object[0]), cause);
    }

    public DmnTransformException errorWhileTransforming(Throwable cause) {
        return new DmnTransformException(this.exceptionMessage("007", "Error while transforming model: " + cause.getMessage(), new Object[0]), cause);
    }

    public DmnTransformException noElementHandlerForClassRegistered(Class<?> elementClass) {
        return new DmnTransformException(this.exceptionMessage("008", "No element handler for element class '{}' registered.", new Object[]{elementClass}));
    }

    public DmnTransformException unableToFindInputEntry(String inputEntryKey) {
        return new DmnTransformException(this.exceptionMessage("009", "Unable to find input entry with id '{}'.", new Object[]{inputEntryKey}));
    }

    public DmnTransformException unableToFindOutputEntry(String outputEntryKey) {
        return new DmnTransformException(this.exceptionMessage("009", "Unable to find output entry with id '{}'.", new Object[]{outputEntryKey}));
    }
}

