/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import org.camunda.bpm.dmn.engine.DmnTypeDefinition;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.type.DataTypeTransformer;
import org.camunda.commons.utils.EnsureUtil;

public class DmnTypeDefinitionImpl
implements DmnTypeDefinition {
    protected static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected String typeName;
    protected DataTypeTransformer transformer;

    @Override
    public Object transform(Object value) {
        if (value == null) {
            return value;
        }
        return this.transformNotNullValue(value);
    }

    protected Object transformNotNullValue(Object value) {
        EnsureUtil.ensureNotNull((String)"transformer", (Object)this.transformer);
        try {
            return this.transformer.transform(value);
        }
        catch (IllegalArgumentException e) {
            throw LOG.invalidOutputValue(this.typeName, value);
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTransformer(DataTypeTransformer transformer) {
        this.transformer = transformer;
    }

    public String toString() {
        return "DmnTypeDefinitionImpl{typeName='" + this.typeName + '\'' + '}';
    }
}

