/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.dmn.engine.DmnClause;
import org.camunda.bpm.dmn.engine.DmnClauseEntry;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTable;
import org.camunda.bpm.dmn.engine.DmnDecisionTableListener;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableRule;
import org.camunda.bpm.dmn.engine.DmnDecisionTableValue;
import org.camunda.bpm.dmn.engine.DmnExpression;
import org.camunda.bpm.dmn.engine.DmnItemDefinition;
import org.camunda.bpm.dmn.engine.DmnRule;
import org.camunda.bpm.dmn.engine.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.context.DmnDecisionContext;
import org.camunda.bpm.dmn.engine.hitpolicy.DmnHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionOutputImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionResultImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableResultImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableRuleImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableValueImpl;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.model.dmn.HitPolicy;

public class DmnDecisionContextImpl
implements DmnDecisionContext {
    protected static final DmnEngineLogger LOG = DmnEngineLogger.ENGINE_LOGGER;
    public static final String DEFAULT_SCRIPT_LANGUAGE = "juel";
    protected DmnScriptEngineResolver scriptEngineResolver;
    protected Map<HitPolicy, DmnHitPolicyHandler> hitPolicyHandlers;
    protected List<DmnDecisionTableListener> decisionTableListeners = new ArrayList<DmnDecisionTableListener>();

    public DmnScriptEngineResolver getScriptEngineResolver() {
        return this.scriptEngineResolver;
    }

    public void setScriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.scriptEngineResolver = scriptEngineResolver;
    }

    public Map<HitPolicy, DmnHitPolicyHandler> getHitPolicyHandlers() {
        return this.hitPolicyHandlers;
    }

    public DmnHitPolicyHandler getHitPolicyHandler(HitPolicy hitPolicy) {
        if (this.hitPolicyHandlers == null) {
            return null;
        }
        return this.hitPolicyHandlers.get(hitPolicy);
    }

    public DmnHitPolicyHandler getHitPolicyHandlerChecked(HitPolicy hitPolicy) {
        DmnHitPolicyHandler hitPolicyHandler = this.getHitPolicyHandler(hitPolicy);
        if (hitPolicyHandler != null) {
            return hitPolicyHandler;
        }
        throw LOG.unableToFindHitPolicyHandlerFor(hitPolicy);
    }

    public void setHitPolicyHandlers(Map<HitPolicy, DmnHitPolicyHandler> hitPolicyHandlers) {
        this.hitPolicyHandlers = hitPolicyHandlers;
    }

    public List<DmnDecisionTableListener> getDecisionTableListeners() {
        return this.decisionTableListeners;
    }

    public void setDecisionTableListeners(List<DmnDecisionTableListener> decisionTableListeners) {
        this.decisionTableListeners = decisionTableListeners;
    }

    @Override
    public DmnDecisionResult evaluateDecision(DmnDecision decision, Map<String, Object> variables) {
        if (decision instanceof DmnDecisionTable) {
            return this.evaluateDecisionTable((DmnDecisionTable)decision, variables);
        }
        throw LOG.decisionTypeNotSupported(decision);
    }

    protected DmnDecisionResult evaluateDecisionTable(DmnDecisionTable decisionTable, Map<String, Object> variables) {
        HashMap<String, Object> evaluationCache = new HashMap<String, Object>();
        DmnDecisionTableResultImpl decisionTableResult = new DmnDecisionTableResultImpl();
        decisionTableResult.setExecutedDecisionElements(this.calculateExecutedDecisionElements(decisionTable));
        Map<String, DmnDecisionTableValue> inputs = this.evaluateDecisionTableInputs(decisionTable, variables, evaluationCache);
        decisionTableResult.setInputs(inputs);
        List<DmnDecisionTableRule> matchingRules = decisionTableResult.getMatchingRules();
        for (DmnRule rule : decisionTable.getRules()) {
            if (!this.isRuleApplicable(rule, variables, inputs, evaluationCache)) continue;
            DmnDecisionTableRuleImpl matchingRule = this.evaluateMatchingRule(rule, variables, evaluationCache);
            matchingRules.add(matchingRule);
        }
        return this.generateDecisionTableResult(decisionTable, decisionTableResult);
    }

    protected DmnDecisionResult generateDecisionTableResult(DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult) {
        DmnHitPolicyHandler hitPolicyHandler = this.getHitPolicyHandlerChecked(decisionTable.getHitPolicy());
        decisionTableResult = hitPolicyHandler.apply(decisionTable, decisionTableResult);
        for (DmnDecisionTableListener decisionTableListener : this.decisionTableListeners) {
            decisionTableListener.notify(decisionTable, decisionTableResult);
        }
        return this.generateDecisionResult(decisionTableResult);
    }

    protected DmnDecisionResult generateDecisionResult(DmnDecisionTableResult decisionTableResult) {
        DmnDecisionResultImpl decisionResult = new DmnDecisionResultImpl();
        if (decisionTableResult.getCollectResultName() != null || decisionTableResult.getCollectResultValue() != null) {
            DmnDecisionOutputImpl decisionOutput = new DmnDecisionOutputImpl();
            decisionOutput.put(decisionTableResult.getCollectResultName(), decisionTableResult.getCollectResultValue());
            decisionResult.add(decisionOutput);
        } else {
            for (DmnDecisionTableRule matchingRule : decisionTableResult.getMatchingRules()) {
                DmnDecisionOutputImpl decisionOutput = new DmnDecisionOutputImpl();
                for (DmnDecisionTableValue outputValue : matchingRule.getOutputs().values()) {
                    decisionOutput.put(outputValue.getOutputName(), outputValue.getValue());
                }
                decisionResult.add(decisionOutput);
            }
        }
        return decisionResult;
    }

    protected long calculateExecutedDecisionElements(DmnDecisionTable decisionTable) {
        return decisionTable.getClauses().size() * decisionTable.getRules().size();
    }

    protected Map<String, DmnDecisionTableValue> evaluateDecisionTableInputs(DmnDecisionTable decisionTable, Map<String, Object> variables, Map<String, Object> evaluationCache) {
        HashMap<String, DmnDecisionTableValue> inputs = new HashMap<String, DmnDecisionTableValue>();
        for (DmnClause clause : decisionTable.getClauses()) {
            if (!clause.isInputClause()) continue;
            DmnDecisionTableValue input = this.evaluateInputClause(clause, variables, evaluationCache);
            inputs.put(input.getKey(), input);
        }
        return inputs;
    }

    protected DmnDecisionTableValue evaluateInputClause(DmnClause clause, Map<String, Object> variables, Map<String, Object> evaluationCache) {
        DmnDecisionTableValueImpl input = new DmnDecisionTableValueImpl(clause);
        DmnExpression inputExpression = clause.getInputExpression();
        if (inputExpression != null) {
            Object value = this.evaluateExpression(inputExpression, variables, evaluationCache);
            if (this.hasItemDefinitionWithTypeDefinition(inputExpression)) {
                value = inputExpression.getItemDefinition().getTypeDefinition().transform(value);
            }
            input.setValue(value);
        }
        return input;
    }

    protected boolean hasItemDefinitionWithTypeDefinition(DmnExpression expression) {
        DmnItemDefinition itemDefinition = expression.getItemDefinition();
        return itemDefinition != null && itemDefinition.getTypeDefinition() != null;
    }

    protected boolean isRuleApplicable(DmnRule rule, Map<String, Object> variables, Map<String, DmnDecisionTableValue> inputs, Map<String, Object> evaluationCache) {
        HashMap<String, Boolean> clauseSatisfied = new HashMap<String, Boolean>();
        List<DmnClauseEntry> conditions = rule.getConditions();
        for (DmnClauseEntry condition : conditions) {
            String clauseKey = condition.getClause().getKey();
            Boolean alreadySatisfied = (Boolean)clauseSatisfied.get(clauseKey);
            if (alreadySatisfied != null && alreadySatisfied.booleanValue()) continue;
            HashMap<String, Object> localVariables = new HashMap<String, Object>(variables);
            if (inputs.containsKey(clauseKey)) {
                DmnDecisionTableValue inputValue = inputs.get(clauseKey);
                localVariables.put(inputValue.getOutputName(), inputValue.getValue());
            }
            boolean applicable = this.isExpressionApplicable(condition, localVariables, evaluationCache);
            clauseSatisfied.put(clauseKey, applicable);
        }
        return !clauseSatisfied.containsValue(false);
    }

    protected DmnDecisionTableRuleImpl evaluateMatchingRule(DmnRule rule, Map<String, Object> variables, Map<String, Object> evaluationCache) {
        DmnDecisionTableRuleImpl matchingRule = new DmnDecisionTableRuleImpl();
        matchingRule.setKey(rule.getKey());
        Map<String, DmnDecisionTableValue> ruleOutputs = this.evaluateRuleOutput(rule, variables, evaluationCache);
        matchingRule.setOutputs(ruleOutputs);
        return matchingRule;
    }

    protected Map<String, DmnDecisionTableValue> evaluateRuleOutput(DmnRule rule, Map<String, Object> variables, Map<String, Object> evaluationCache) {
        HashMap<String, DmnDecisionTableValue> outputs = new HashMap<String, DmnDecisionTableValue>();
        for (DmnClauseEntry conclusion : rule.getConclusions()) {
            DmnDecisionTableValueImpl output = new DmnDecisionTableValueImpl(conclusion.getClause());
            Object value = this.evaluateExpression(conclusion, variables, evaluationCache);
            if (this.hasOutputDefinitionWithTypeDefinition(conclusion)) {
                value = conclusion.getClause().getOutputDefinition().getTypeDefinition().transform(value);
            }
            output.setValue(value);
            outputs.put(output.getKey(), output);
        }
        return outputs;
    }

    protected boolean isExpressionApplicable(DmnExpression expression, Map<String, Object> variables, Map<String, Object> evaluationCache) {
        Object result = this.evaluateExpression(expression, variables, evaluationCache);
        return result != null && result.equals(true);
    }

    protected Object evaluateExpression(DmnExpression expression, Map<String, Object> variables, Map<String, Object> evaluationCache) {
        String expressionKey = expression.getKey();
        if (evaluationCache != null && evaluationCache.containsKey(expressionKey)) {
            return evaluationCache.get(expressionKey);
        }
        Object value = this.evaluateExpression(expression, variables);
        if (evaluationCache != null) {
            evaluationCache.put(expressionKey, value);
        }
        return value;
    }

    protected boolean hasOutputDefinitionWithTypeDefinition(DmnClauseEntry conclusion) {
        DmnItemDefinition outputDefinition = conclusion.getClause().getOutputDefinition();
        return outputDefinition != null && outputDefinition.getTypeDefinition() != null;
    }

    protected Object evaluateExpression(DmnExpression expression, Map<String, Object> variables) {
        String expressionText = expression.getExpression();
        if (expressionText != null) {
            String expressionLanguage = expression.getExpressionLanguage();
            ScriptEngine scriptEngine = this.getScriptEngineForNameChecked(expressionLanguage);
            Bindings bindings = this.createBindings(scriptEngine, variables);
            try {
                return scriptEngine.eval(expressionText, bindings);
            }
            catch (ScriptException e) {
                throw LOG.unableToEvaluateExpression(expressionText, scriptEngine.getFactory().getLanguageName(), e);
            }
        }
        return null;
    }

    protected ScriptEngine getScriptEngineForNameChecked(String expressionLanguage) {
        ScriptEngine scriptEngine = this.getScriptEngineForName(expressionLanguage);
        if (scriptEngine != null) {
            return scriptEngine;
        }
        throw LOG.noScriptEngineFoundForLanguage(expressionLanguage, DEFAULT_SCRIPT_LANGUAGE);
    }

    protected ScriptEngine getScriptEngineForName(String expressionLanguage) {
        if (expressionLanguage == null) {
            expressionLanguage = DEFAULT_SCRIPT_LANGUAGE;
        }
        return this.scriptEngineResolver.getScriptEngineForLanguage(expressionLanguage);
    }

    protected Bindings createBindings(ScriptEngine scriptEngine, Map<String, Object> variables) {
        Bindings bindings = scriptEngine.createBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)variables);
        return bindings;
    }
}

