/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.handler;

import org.camunda.bpm.dmn.engine.handler.DmnElementHandlerContext;
import org.camunda.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.handler.AbstractDmnElementHandler;
import org.camunda.bpm.model.dmn.instance.LiteralExpression;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.commons.utils.StringUtil;

public abstract class AbstractDmnLiteralExpressionHandler<E extends LiteralExpression, I extends DmnExpressionImpl>
extends AbstractDmnElementHandler<E, I> {
    @Override
    protected I createElement(DmnElementHandlerContext context, E expression) {
        return (I)new DmnExpressionImpl();
    }

    @Override
    protected void initElement(DmnElementHandlerContext context, E expression, I dmnExpression) {
        super.initElement(context, expression, dmnExpression);
        this.initExpressionLanguage(context, expression, (DmnExpressionImpl)dmnExpression);
        this.initExpression(context, expression, (DmnExpressionImpl)dmnExpression);
    }

    protected void initExpressionLanguage(DmnElementHandlerContext context, E expression, DmnExpressionImpl dmnExpression) {
        String expressionLanguage = expression.getExpressionLanguage();
        if (expressionLanguage != null) {
            dmnExpression.setExpressionLanguage(expressionLanguage.trim());
        }
    }

    protected void initExpression(DmnElementHandlerContext context, E expression, DmnExpressionImpl dmnExpression) {
        String textContent;
        Text text = expression.getText();
        if (text != null && (textContent = text.getTextContent()) != null && !textContent.trim().isEmpty()) {
            dmnExpression.setExpression(textContent.trim());
            this.postProcessExpressionText(context, expression, dmnExpression);
        }
    }

    protected void postProcessExpressionText(DmnElementHandlerContext context, E expression, DmnExpressionImpl dmnExpression) {
    }

    protected boolean hasJuelExpressionLanguage(DmnExpressionImpl dmnExpression) {
        String expressionLanguage = dmnExpression.getExpressionLanguage();
        if (expressionLanguage == null) {
            expressionLanguage = "juel";
        }
        return "juel".equals(expressionLanguage);
    }

    protected boolean isExpression(DmnExpressionImpl dmnExpression) {
        return StringUtil.isExpression((String)dmnExpression.getExpression());
    }
}

