/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.handler;

import org.camunda.bpm.dmn.engine.DmnClause;
import org.camunda.bpm.dmn.engine.handler.DmnElementHandlerContext;
import org.camunda.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.handler.AbstractDmnClauseHandler;
import org.camunda.bpm.model.dmn.instance.InputEntry;

public class DmnInputEntryHandler
extends AbstractDmnClauseHandler<InputEntry> {
    @Override
    protected void postProcessExpressionText(DmnElementHandlerContext context, InputEntry expression, DmnExpressionImpl dmnExpression) {
        if (this.hasJuelExpressionLanguage(dmnExpression) && !this.isExpression(dmnExpression)) {
            String expressionText = dmnExpression.getExpression();
            String variableName = this.getVariableName(context);
            if (this.startsWithOperator(expressionText)) {
                dmnExpression.setExpression("${" + variableName + expressionText + "}");
            } else if (this.isNumber(expressionText)) {
                dmnExpression.setExpression("${" + variableName + "==" + expressionText + "}");
            } else if (this.isBoolean(expressionText)) {
                Boolean booleanValue = Boolean.parseBoolean(expressionText.trim());
                dmnExpression.setExpression("${" + variableName + "==" + booleanValue + "}");
            } else {
                dmnExpression.setExpression("${" + variableName + "=='" + expressionText + "'}");
            }
        }
    }

    protected String getVariableName(DmnElementHandlerContext context) {
        DmnClause clause = (DmnClause)context.getParent();
        return clause.getOutputName();
    }

    protected boolean isNumber(String text) {
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isBoolean(String text) {
        return text != null && (text.trim().equalsIgnoreCase("true") || text.trim().equalsIgnoreCase("false"));
    }

    protected boolean startsWithOperator(String text) {
        char firstChar = text.trim().charAt(0);
        return !Character.isLetterOrDigit(firstChar);
    }
}

