/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.handler;

import org.camunda.bpm.dmn.engine.handler.DmnElementHandler;
import org.camunda.bpm.dmn.engine.handler.DmnElementHandlerContext;
import org.camunda.bpm.dmn.engine.impl.DmnTypeDefinitionImpl;
import org.camunda.bpm.dmn.engine.type.DataTypeTransformer;
import org.camunda.bpm.dmn.engine.type.DataTypeTransformerFactory;
import org.camunda.bpm.model.dmn.instance.TypeDefinition;
import org.camunda.commons.utils.EnsureUtil;

public class DmnTypeDefinitionHandler
implements DmnElementHandler<TypeDefinition, DmnTypeDefinitionImpl> {
    @Override
    public DmnTypeDefinitionImpl handleElement(DmnElementHandlerContext context, TypeDefinition typeDefinition) {
        DmnTypeDefinitionImpl dmnTypeDefinition = this.createElement(context, typeDefinition);
        this.initElement(context, typeDefinition, dmnTypeDefinition);
        return dmnTypeDefinition;
    }

    protected DmnTypeDefinitionImpl createElement(DmnElementHandlerContext context, TypeDefinition typeDefinition) {
        return new DmnTypeDefinitionImpl();
    }

    protected void initElement(DmnElementHandlerContext context, TypeDefinition typeDefinition, DmnTypeDefinitionImpl dmnTypeDefinition) {
        this.initTypeName(context, typeDefinition, dmnTypeDefinition);
        this.initDataTypeTransformer(context, typeDefinition, dmnTypeDefinition);
    }

    protected void initTypeName(DmnElementHandlerContext context, TypeDefinition typeDefinition, DmnTypeDefinitionImpl dmnTypeDefinition) {
        dmnTypeDefinition.setTypeName(typeDefinition.getTextContent());
    }

    protected void initDataTypeTransformer(DmnElementHandlerContext context, TypeDefinition typeDefinition, DmnTypeDefinitionImpl dmnTypeDefinition) {
        DataTypeTransformerFactory factory = context.getDataTypeTransformerFactory();
        EnsureUtil.ensureNotNull((String)"data type transformer factory", (Object)factory);
        DataTypeTransformer transformer = factory.getTransformerForType(dmnTypeDefinition.getTypeName());
        EnsureUtil.ensureNotNull((String)"data type transformer", (Object)transformer);
        dmnTypeDefinition.setTransformer(transformer);
    }
}

