/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.dmn.engine.hitpolicy.DmnHitPolicyAggregator;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.DmnHitPolicyException;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.DmnHitPolicyLogger;

public abstract class AbstractDmnHitPolicyNumberAggregator
implements DmnHitPolicyAggregator {
    public static final DmnHitPolicyLogger LOG = DmnLogger.HIT_POLICY_LOGGER;

    @Override
    public Number aggregate(List<Object> outputValues) {
        if (outputValues.isEmpty()) {
            return null;
        }
        return this.aggregateNumberValues(outputValues);
    }

    protected Number aggregateNumberValues(List<Object> values) {
        try {
            List<Integer> intValues = this.convertValuesToInteger(values);
            return this.aggregateIntegerValues(intValues);
        }
        catch (DmnHitPolicyException e) {
            try {
                List<Long> longValues = this.convertValuesToLong(values);
                return this.aggregateLongValues(longValues);
            }
            catch (DmnHitPolicyException e2) {
                try {
                    List<Double> doubleValues = this.convertValuesToDouble(values);
                    return this.aggregateDoubleValues(doubleValues);
                }
                catch (DmnHitPolicyException dmnHitPolicyException) {
                    throw LOG.unableToConvertValuesToAggregatableTypes(values, Integer.class, Long.class, Double.class);
                }
            }
        }
    }

    protected abstract Number aggregateIntegerValues(List<Integer> var1);

    protected abstract Number aggregateLongValues(List<Long> var1);

    protected abstract Number aggregateDoubleValues(List<Double> var1);

    protected List<Integer> convertValuesToInteger(List<Object> values) {
        ArrayList<Integer> intValues = new ArrayList<Integer>();
        for (Object value : values) {
            if (value instanceof Integer) {
                intValues.add((Integer)value);
                continue;
            }
            try {
                intValues.add(Integer.valueOf(value.toString()));
            }
            catch (NumberFormatException e) {
                throw LOG.unableToConvertValueTo(Integer.class, value, e);
            }
        }
        return intValues;
    }

    protected List<Long> convertValuesToLong(List<Object> values) {
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (Object value : values) {
            if (value instanceof Long) {
                longValues.add((Long)value);
                continue;
            }
            try {
                longValues.add(Long.valueOf(value.toString()));
            }
            catch (NumberFormatException e) {
                throw LOG.unableToConvertValueTo(Long.class, value, e);
            }
        }
        return longValues;
    }

    protected List<Double> convertValuesToDouble(List<Object> values) {
        ArrayList<Double> doubleValues = new ArrayList<Double>();
        for (Object value : values) {
            if (value instanceof Double) {
                doubleValues.add((Double)value);
                continue;
            }
            try {
                doubleValues.add(Double.valueOf(value.toString()));
            }
            catch (NumberFormatException e) {
                throw LOG.unableToConvertValueTo(Double.class, value, e);
            }
        }
        return doubleValues;
    }
}

