/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.hitpolicy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTable;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableRule;
import org.camunda.bpm.dmn.engine.DmnDecisionTableValue;
import org.camunda.bpm.dmn.engine.hitpolicy.DmnHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableResultImpl;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.DmnHitPolicyLogger;

public class AnyHitPolicyHandler
implements DmnHitPolicyHandler {
    public static final DmnHitPolicyLogger LOG = DmnLogger.HIT_POLICY_LOGGER;

    @Override
    public DmnDecisionTableResult apply(DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult) {
        List<DmnDecisionTableRule> matchingRules = decisionTableResult.getMatchingRules();
        if (!matchingRules.isEmpty()) {
            if (this.allOutputsAreEqual(matchingRules)) {
                DmnDecisionTableRule firstMatchingRule = matchingRules.get(0);
                ((DmnDecisionTableResultImpl)decisionTableResult).setMatchingRules(Collections.singletonList(firstMatchingRule));
            } else {
                throw LOG.anyHitPolicyRequiresThatAllOutputsAreEqual(matchingRules);
            }
        }
        return decisionTableResult;
    }

    protected boolean allOutputsAreEqual(List<DmnDecisionTableRule> matchingRules) {
        Map<String, DmnDecisionTableValue> firstOutputs = matchingRules.get(0).getOutputs();
        if (firstOutputs == null) {
            for (int i = 1; i < matchingRules.size(); ++i) {
                if (matchingRules.get(i).getOutputs() == null) continue;
                return false;
            }
        } else {
            for (int i = 1; i < matchingRules.size(); ++i) {
                if (((Object)firstOutputs).equals(matchingRules.get(i).getOutputs())) continue;
                return false;
            }
        }
        return true;
    }
}

