/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTable;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableRule;
import org.camunda.bpm.dmn.engine.DmnDecisionTableValue;
import org.camunda.bpm.dmn.engine.hitpolicy.DmnHitPolicyAggregator;
import org.camunda.bpm.dmn.engine.hitpolicy.DmnHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableResultImpl;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectCountAggregator;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectMaxAggregator;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectMinAggregator;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectSumAggregator;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.DmnHitPolicyLogger;
import org.camunda.bpm.model.dmn.BuiltinAggregator;

public class CollectHitPolicyHandler
implements DmnHitPolicyHandler {
    public static final DmnHitPolicyLogger LOG = DmnLogger.HIT_POLICY_LOGGER;
    public static final Map<BuiltinAggregator, DmnHitPolicyAggregator> AGGREGATORS = new HashMap<BuiltinAggregator, DmnHitPolicyAggregator>();

    @Override
    public DmnDecisionTableResult apply(DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult) {
        BuiltinAggregator aggregation = decisionTable.getAggregation();
        if (aggregation != null) {
            this.aggregateDecisionTableResult(aggregation, (DmnDecisionTableResultImpl)decisionTableResult);
        }
        return decisionTableResult;
    }

    protected void aggregateDecisionTableResult(BuiltinAggregator aggregation, DmnDecisionTableResultImpl decisionTableResult) {
        DmnHitPolicyAggregator aggregator = AGGREGATORS.get(aggregation);
        if (aggregator == null) {
            throw LOG.noAggregatorFoundFor(aggregation);
        }
        List<DmnDecisionTableRule> matchingRules = decisionTableResult.getMatchingRules();
        List<Object> outputValues = this.collectSingleValues(aggregation, matchingRules);
        String outputName = this.getDecisionOutputName(matchingRules);
        Number outputValue = aggregator.aggregate(outputValues);
        decisionTableResult.setCollectResultName(outputName);
        decisionTableResult.setCollectResultValue(outputValue);
    }

    protected List<Object> collectSingleValues(BuiltinAggregator aggregator, List<DmnDecisionTableRule> matchingRules) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (DmnDecisionTableRule matchingRule : matchingRules) {
            Map<String, DmnDecisionTableValue> outputs = matchingRule.getOutputs();
            if (outputs.isEmpty()) continue;
            if (outputs.size() == 1) {
                values.add(outputs.values().iterator().next().getValue());
                continue;
            }
            throw LOG.aggregationNotApplicableOnCompoundOutput(aggregator, outputs);
        }
        return values;
    }

    protected String getDecisionOutputName(List<DmnDecisionTableRule> matchingRules) {
        for (DmnDecisionTableRule matchingRule : matchingRules) {
            Map<String, DmnDecisionTableValue> outputs = matchingRule.getOutputs();
            if (outputs.isEmpty()) continue;
            return outputs.values().iterator().next().getOutputName();
        }
        return null;
    }

    static {
        AGGREGATORS.put(BuiltinAggregator.SUM, new CollectSumAggregator());
        AGGREGATORS.put(BuiltinAggregator.MIN, new CollectMinAggregator());
        AGGREGATORS.put(BuiltinAggregator.MAX, new CollectMaxAggregator());
        AGGREGATORS.put(BuiltinAggregator.COUNT, new CollectCountAggregator());
    }
}

