/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.transform;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnClause;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionModel;
import org.camunda.bpm.dmn.engine.DmnExpression;
import org.camunda.bpm.dmn.engine.DmnItemDefinition;
import org.camunda.bpm.dmn.engine.DmnRule;
import org.camunda.bpm.dmn.engine.handler.DmnElementHandler;
import org.camunda.bpm.dmn.engine.handler.DmnElementHandlerContext;
import org.camunda.bpm.dmn.engine.handler.DmnElementHandlerRegistry;
import org.camunda.bpm.dmn.engine.impl.DmnClauseEntryImpl;
import org.camunda.bpm.dmn.engine.impl.DmnClauseImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionModelImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.camunda.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.DmnItemDefinitionImpl;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.DmnRuleImpl;
import org.camunda.bpm.dmn.engine.impl.DmnTransformLogger;
import org.camunda.bpm.dmn.engine.impl.DmnTypeDefinitionImpl;
import org.camunda.bpm.dmn.engine.transform.DmnTransform;
import org.camunda.bpm.dmn.engine.transform.DmnTransformListener;
import org.camunda.bpm.dmn.engine.transform.DmnTransformer;
import org.camunda.bpm.dmn.engine.type.DataTypeTransformerFactory;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.AllowedValue;
import org.camunda.bpm.model.dmn.instance.Clause;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.DmnModelElementInstance;
import org.camunda.bpm.model.dmn.instance.Expression;
import org.camunda.bpm.model.dmn.instance.InputEntry;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.ItemDefinition;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.bpm.model.dmn.instance.TypeDefinition;

public class DmnTransformImpl
implements DmnTransform,
DmnElementHandlerContext {
    private static final DmnTransformLogger LOG = DmnLogger.TRANSFORM_LOGGER;
    protected DmnTransformer transformer;
    protected DmnElementHandlerRegistry elementHandlerRegistry;
    protected List<DmnTransformListener> transformListeners;
    protected DataTypeTransformerFactory dataTypeTransformerFactory;
    protected DmnModelInstance modelInstance;
    protected DmnDecisionModelImpl decisionModel;
    protected DmnDecisionTableImpl decision;
    protected Object parent;
    protected Map<String, DmnClauseEntryImpl> inputEntries = new HashMap<String, DmnClauseEntryImpl>();
    protected Map<String, DmnClauseEntryImpl> outputEntries = new HashMap<String, DmnClauseEntryImpl>();

    public DmnTransformImpl(DmnTransformer transformer) {
        this.transformer = transformer;
        this.elementHandlerRegistry = transformer.getElementHandlerRegistry();
        this.transformListeners = transformer.getTransformListeners();
        this.dataTypeTransformerFactory = transformer.getDataTypeTransformerFactory();
    }

    @Override
    public DmnTransform setModelInstance(File file) {
        try {
            this.modelInstance = Dmn.readModelFromFile((File)file);
        }
        catch (DmnModelException e) {
            throw LOG.unableToTransformModelFromFile(file, e);
        }
        return this;
    }

    @Override
    public DmnTransform setModelInstance(InputStream inputStream) {
        try {
            this.modelInstance = Dmn.readModelFromStream((InputStream)inputStream);
        }
        catch (DmnModelException e) {
            throw LOG.unableToTransformModelFromInputStream(e);
        }
        return this;
    }

    @Override
    public DmnTransform setModelInstance(DmnModelInstance modelInstance) {
        this.modelInstance = modelInstance;
        return this;
    }

    @Override
    public DmnDecisionModel transform() {
        try {
            return this.transformDefinitions();
        }
        catch (Exception e) {
            throw LOG.errorWhileTransforming(e);
        }
    }

    protected DmnDecisionModel transformDefinitions() {
        DmnElementHandler definitionsHandler = this.getElementHandler(Definitions.class);
        Definitions definitions = this.modelInstance.getDefinitions();
        this.decisionModel = (DmnDecisionModelImpl)definitionsHandler.handleElement(this, definitions);
        this.transformItemDefinitions();
        this.transformDecisions();
        this.notifyTransformListeners(definitions, this.decisionModel);
        return this.decisionModel;
    }

    protected void transformItemDefinitions() {
        Collection itemDefinitions = this.modelInstance.getDefinitions().getItemDefinitions();
        for (ItemDefinition itemDefinition : itemDefinitions) {
            this.transformItemDefinition(itemDefinition);
        }
    }

    protected void transformItemDefinition(ItemDefinition itemDefinition) {
        DmnElementHandler itemDefinitionHandler = this.getElementHandler(ItemDefinition.class);
        DmnElementHandler typeDefinitionHandler = this.getElementHandler(TypeDefinition.class);
        DmnElementHandler allowedValueHandler = this.getElementHandler(AllowedValue.class);
        DmnItemDefinitionImpl dmnItemDefinition = (DmnItemDefinitionImpl)itemDefinitionHandler.handleElement(this, itemDefinition);
        TypeDefinition typeDefinition = itemDefinition.getTypeDefinition();
        if (typeDefinition != null) {
            this.parent = dmnItemDefinition;
            DmnTypeDefinitionImpl dmnTypeDefinition = (DmnTypeDefinitionImpl)typeDefinitionHandler.handleElement(this, typeDefinition);
            dmnItemDefinition.setTypeDefinition(dmnTypeDefinition);
        }
        for (AllowedValue allowedValue : itemDefinition.getAllowedValues()) {
            this.parent = itemDefinition;
            DmnExpressionImpl dmnExpression = (DmnExpressionImpl)allowedValueHandler.handleElement(this, allowedValue);
            dmnItemDefinition.addAllowedValue(dmnExpression);
        }
        this.notifyTransformListeners(itemDefinition, dmnItemDefinition);
        this.decisionModel.addItemDefinition(dmnItemDefinition);
    }

    protected void transformDecisions() {
        Collection decisions = this.modelInstance.getDefinitions().getChildElementsByType(Decision.class);
        for (Decision decision : decisions) {
            this.transformDecision(decision);
        }
    }

    protected void transformDecision(Decision decision) {
        DmnDecision dmnDecision = null;
        Expression expression = decision.getExpression();
        if (expression instanceof DecisionTable) {
            dmnDecision = this.transformDecisionTable((DecisionTable)expression);
        } else {
            LOG.decisionTypeNotSupported(decision);
        }
        if (dmnDecision != null) {
            this.notifyTransformListeners(decision, dmnDecision);
            this.decisionModel.addDecision(dmnDecision);
        }
    }

    protected DmnDecision transformDecisionTable(DecisionTable decisionTable) {
        DmnDecisionTableImpl dmnDecision;
        DmnElementHandler decisionTableHandler = this.getElementHandler(DecisionTable.class);
        this.decision = dmnDecision = (DmnDecisionTableImpl)decisionTableHandler.handleElement(this, decisionTable);
        for (Clause clause : decisionTable.getClauses()) {
            this.parent = dmnDecision;
            this.transformClause(clause);
        }
        for (Rule rule : decisionTable.getRules()) {
            this.parent = dmnDecision;
            this.transformRule(rule);
        }
        return dmnDecision;
    }

    protected void transformClause(Clause clause) {
        DmnClause dmnClause = null;
        if (this.isInputClause(clause)) {
            dmnClause = this.transformInputClause(clause);
        } else if (this.isOutputClause(clause)) {
            dmnClause = this.transformOutputClause(clause);
        } else {
            LOG.ignoringClause(clause);
        }
        if (dmnClause != null) {
            this.notifyTransformListeners(clause, dmnClause);
            this.decision.addClause(dmnClause);
        }
    }

    protected DmnClause transformInputClause(Clause clause) {
        InputExpression inputExpression;
        DmnElementHandler clauseHandler = this.getElementHandler(Clause.class);
        DmnElementHandler inputEntryHandler = this.getElementHandler(InputEntry.class);
        DmnClauseImpl dmnClause = (DmnClauseImpl)clauseHandler.handleElement(this, clause);
        if (dmnClause.getOutputName() == null) {
            dmnClause.setOutputName("cellInput");
        }
        if ((inputExpression = clause.getInputExpression()) != null) {
            this.parent = dmnClause;
            DmnExpression dmnInputExpression = this.transformInputExpression(inputExpression);
            dmnClause.setInputExpression(dmnInputExpression);
        }
        for (InputEntry inputEntry : clause.getInputEntries()) {
            this.parent = dmnClause;
            DmnClauseEntryImpl dmnInputEntry = (DmnClauseEntryImpl)inputEntryHandler.handleElement(this, inputEntry);
            this.inputEntries.put(dmnInputEntry.getKey(), dmnInputEntry);
            dmnInputEntry.setClause(dmnClause);
            dmnClause.addInputEntry(dmnInputEntry);
        }
        return dmnClause;
    }

    protected DmnExpression transformInputExpression(InputExpression inputExpression) {
        String itemDefinitionRef;
        DmnItemDefinition itemDefinition;
        DmnElementHandler inputExpressionHandler = this.getElementHandler(InputExpression.class);
        DmnExpressionImpl dmnInputExpression = (DmnExpressionImpl)inputExpressionHandler.handleElement(this, inputExpression);
        if (inputExpression.getItemDefinition() != null && (itemDefinition = this.decisionModel.getItemDefinition(itemDefinitionRef = inputExpression.getItemDefinition().getId())) != null) {
            dmnInputExpression.setItemDefinition(itemDefinition);
        }
        return dmnInputExpression;
    }

    protected DmnClause transformOutputClause(Clause clause) {
        String itemDefinitionRef;
        DmnItemDefinition itemDefinition;
        DmnElementHandler clauseHandler = this.getElementHandler(Clause.class);
        DmnElementHandler outputEntryHandler = this.getElementHandler(OutputEntry.class);
        DmnClauseImpl dmnClause = (DmnClauseImpl)clauseHandler.handleElement(this, clause);
        if (clause.getOutputDefinition() != null && (itemDefinition = this.decisionModel.getItemDefinition(itemDefinitionRef = clause.getOutputDefinition().getId())) != null) {
            dmnClause.setOutputDefinition(itemDefinition);
        }
        for (OutputEntry outputEntry : clause.getOutputEntries()) {
            this.parent = dmnClause;
            DmnClauseEntryImpl dmnOutputEntry = (DmnClauseEntryImpl)outputEntryHandler.handleElement(this, outputEntry);
            this.outputEntries.put(dmnOutputEntry.getKey(), dmnOutputEntry);
            dmnOutputEntry.setClause(dmnClause);
            dmnClause.addOutputEntry(dmnOutputEntry);
        }
        return dmnClause;
    }

    protected void transformRule(Rule rule) {
        DmnElementHandler ruleHandler = this.getElementHandler(Rule.class);
        DmnRuleImpl dmnRule = (DmnRuleImpl)ruleHandler.handleElement(this, rule);
        for (Expression condition : rule.getConditions()) {
            this.parent = dmnRule;
            DmnClauseEntryImpl dmnCondition = this.transformCondition(condition);
            dmnRule.addCondition(dmnCondition);
        }
        for (Expression conclusion : rule.getConclusions()) {
            this.parent = dmnRule;
            DmnClauseEntryImpl dmnConclusion = this.transformConclusion(conclusion);
            dmnRule.addConclusion(dmnConclusion);
        }
        this.notifyTransformListeners(rule, dmnRule);
        this.decision.addRule(dmnRule);
    }

    protected DmnClauseEntryImpl transformCondition(Expression condition) {
        DmnClauseEntryImpl inputEntry = this.inputEntries.get(condition.getId());
        if (inputEntry != null) {
            return inputEntry;
        }
        throw LOG.unableToFindInputEntry(condition.getId());
    }

    protected DmnClauseEntryImpl transformConclusion(Expression conclusion) {
        DmnClauseEntryImpl outputEntry = this.outputEntries.get(conclusion.getId());
        if (outputEntry != null) {
            return outputEntry;
        }
        throw LOG.unableToFindOutputEntry(conclusion.getId());
    }

    protected boolean isInputClause(Clause clause) {
        return clause.getInputExpression() != null || !clause.getInputEntries().isEmpty();
    }

    protected boolean isOutputClause(Clause clause) {
        return clause.getOutputDefinition() != null || !clause.getOutputEntries().isEmpty();
    }

    protected <Source extends DmnModelElementInstance, Target> DmnElementHandler<Source, Target> getElementHandler(Class<Source> elementClass) {
        DmnElementHandler elementHandler = this.elementHandlerRegistry.getElementHandler(elementClass);
        if (elementHandler == null) {
            throw LOG.noElementHandlerForClassRegistered(elementClass);
        }
        return elementHandler;
    }

    protected void notifyTransformListeners(Definitions definitions, DmnDecisionModel decisionModel) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDefinitions(definitions, decisionModel);
        }
    }

    protected void notifyTransformListeners(ItemDefinition itemDefinition, DmnItemDefinition dmnItemDefinition) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformItemDefinition(itemDefinition, dmnItemDefinition);
        }
    }

    protected void notifyTransformListeners(Decision decision, DmnDecision dmnDecision) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecision(decision, dmnDecision);
        }
    }

    protected void notifyTransformListeners(Clause clause, DmnClause dmnClause) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformClause(clause, dmnClause);
        }
    }

    protected void notifyTransformListeners(Rule rule, DmnRule dmnRule) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformRule(rule, dmnRule);
        }
    }

    @Override
    public DmnModelInstance getModelInstance() {
        return this.modelInstance;
    }

    @Override
    public DmnDecisionModel getDecisionModel() {
        return this.decisionModel;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public DmnDecision getDecision() {
        return this.decision;
    }

    @Override
    public DataTypeTransformerFactory getDataTypeTransformerFactory() {
        return this.dataTypeTransformerFactory;
    }
}

