/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.type;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.type.BooleanDataTypeTransformer;
import org.camunda.bpm.dmn.engine.impl.type.DoubleDataTypeTransformer;
import org.camunda.bpm.dmn.engine.impl.type.IdentityDataTypeTransformer;
import org.camunda.bpm.dmn.engine.impl.type.IntegerDataTypeTransformer;
import org.camunda.bpm.dmn.engine.impl.type.LongDataTypeTransformer;
import org.camunda.bpm.dmn.engine.impl.type.StringDataTypeTransformer;
import org.camunda.bpm.dmn.engine.type.DataTypeTransformer;
import org.camunda.bpm.dmn.engine.type.DataTypeTransformerFactory;

public class DefaultDataTypeTransformerFactory
implements DataTypeTransformerFactory {
    protected static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected static final Map<String, DataTypeTransformer> transformers = DefaultDataTypeTransformerFactory.getDefaultTransformers();

    @Override
    public DataTypeTransformer getTransformerForType(String typeName) {
        if (typeName != null && transformers.containsKey(typeName.toLowerCase())) {
            return transformers.get(typeName.toLowerCase());
        }
        LOG.unsupportedOutputDefinitionType(typeName);
        return new IdentityDataTypeTransformer();
    }

    protected static Map<String, DataTypeTransformer> getDefaultTransformers() {
        HashMap<String, DataTypeTransformer> transformers = new HashMap<String, DataTypeTransformer>();
        transformers.put("string", new StringDataTypeTransformer());
        transformers.put("boolean", new BooleanDataTypeTransformer());
        transformers.put("integer", new IntegerDataTypeTransformer());
        transformers.put("long", new LongDataTypeTransformer());
        transformers.put("double", new DoubleDataTypeTransformer());
        return transformers;
    }
}

