/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.type;

import org.camunda.bpm.dmn.engine.type.DataTypeTransformer;

public class IntegerDataTypeTransformer
implements DataTypeTransformer {
    @Override
    public Object transform(Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return this.transformNumber((Number)value);
        }
        if (value instanceof String) {
            return this.transformString((String)value);
        }
        throw new IllegalArgumentException();
    }

    protected Integer transformNumber(Number value) {
        if (this.isInteger(value)) {
            return value.intValue();
        }
        throw new IllegalArgumentException();
    }

    protected boolean isInteger(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((int)doubleValue);
    }

    protected Integer transformString(String value) {
        return Integer.parseInt(value);
    }
}

