/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.type;

import org.camunda.bpm.dmn.engine.type.DataTypeTransformer;

public class LongDataTypeTransformer
implements DataTypeTransformer {
    @Override
    public Object transform(Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return this.transformNumber((Number)value);
        }
        if (value instanceof String) {
            return this.transformString((String)value);
        }
        throw new IllegalArgumentException();
    }

    protected Long transformNumber(Number value) {
        if (this.isLong(value)) {
            return value.longValue();
        }
        throw new IllegalArgumentException();
    }

    protected boolean isLong(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((long)doubleValue);
    }

    protected Long transformString(String value) {
        return Long.parseLong(value);
    }
}

