/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.test;

import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DmnEngineConfigurationImpl;
import org.camunda.bpm.dmn.engine.test.DecisionResource;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class DmnEngineRule
extends TestWatcher {
    public static final String DMN_SUFFIX = "dmn";
    protected DmnEngine engine;
    protected DmnEngineConfiguration configuration;
    protected DmnDecision decision;

    public DmnEngineRule() {
        this(new DmnEngineConfigurationImpl());
    }

    public DmnEngineRule(DmnEngineConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void starting(Description description) {
        if (this.engine == null) {
            this.initializeDmnEngine();
        }
        this.decision = this.loadDecision(description);
    }

    protected void initializeDmnEngine() {
        this.engine = this.configuration.buildEngine();
    }

    protected DmnDecision loadDecision(Description description) {
        DecisionResource decisionResource = (DecisionResource)description.getAnnotation(DecisionResource.class);
        if (decisionResource != null) {
            String resourcePath = decisionResource.resource();
            resourcePath = this.expandResourcePath(description, resourcePath);
            String decisionKey = decisionResource.decisionKey();
            if (decisionKey == null || decisionKey.isEmpty()) {
                return this.engine.parseDecision(resourcePath);
            }
            return this.engine.parseDecision(resourcePath, decisionKey);
        }
        return null;
    }

    protected String expandResourcePath(Description description, String resourcePath) {
        if (resourcePath.contains("/")) {
            return resourcePath;
        }
        Class testClass = description.getTestClass();
        if (resourcePath.isEmpty()) {
            return testClass.getName().replace(".", "/") + "." + description.getMethodName() + "." + DMN_SUFFIX;
        }
        return testClass.getPackage().getName().replace(".", "/") + "/" + resourcePath;
    }

    public DmnEngine getEngine() {
        return this.engine;
    }

    public DmnDecision getDecision() {
        return this.decision;
    }
}

