/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.test.asserts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionModel;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.test.asserts.DmnDecisionOutputAssertion;
import org.camunda.bpm.dmn.engine.test.asserts.DmnDecisionResultAssertion;

public class DmnEngineAssertion
extends AbstractAssert<DmnEngineAssertion, DmnEngine> {
    protected DmnDecision decision;
    protected Map<String, Object> variables = new HashMap<String, Object>();

    protected DmnEngineAssertion(DmnEngine actual) {
        super((Object)actual, DmnEngineAssertion.class);
    }

    public DmnEngineAssertion evaluates(DmnDecision decision, Map<String, Object> variables) {
        this.isNotNull();
        if (decision == null) {
            this.failWithMessage("Expected decision not to be null.", new Object[0]);
        }
        this.decision = decision;
        this.variables = variables;
        return this;
    }

    public DmnEngineAssertion evaluates(DmnDecisionModel decisionModel, Map<String, Object> variables) {
        List decisions = decisionModel.getDecisions();
        if (decisions.isEmpty()) {
            this.failWithMessage("Expected at least one decision in model.", new Object[0]);
        }
        return this.evaluates((DmnDecision)decisions.get(0), variables);
    }

    public DmnEngineAssertion evaluates(DmnDecisionModel decisionModel, String decisionKey, Map<String, Object> variables) {
        Object decision = decisionModel.getDecision(decisionKey);
        return this.evaluates((DmnDecision)decision, variables);
    }

    public DmnDecisionResultAssertion hasResult() {
        this.isNotNull();
        if (this.decision == null) {
            this.failWithMessage("Expected decision not to be null.", new Object[0]);
        }
        DmnDecisionResult result = ((DmnEngine)this.actual).evaluate(this.decision, this.variables);
        return new DmnDecisionResultAssertion(result);
    }

    public DmnDecisionOutputAssertion hasResult(Object value) {
        this.isNotNull();
        if (this.decision == null) {
            this.failWithMessage("Expected decision not to be null.", new Object[0]);
        }
        DmnDecisionResult result = ((DmnEngine)this.actual).evaluate(this.decision, this.variables);
        DmnDecisionResultAssertion resultAssertion = new DmnDecisionResultAssertion(result);
        return resultAssertion.hasSingleOutput().hasSingleEntry(value);
    }

    public DmnDecisionOutputAssertion hasResult(String name, String value) {
        this.isNotNull();
        if (this.decision == null) {
            this.failWithMessage("Expected decision not to be null.", new Object[0]);
        }
        DmnDecisionResult result = ((DmnEngine)this.actual).evaluate(this.decision, this.variables);
        DmnDecisionResultAssertion resultAssertion = new DmnDecisionResultAssertion(result);
        return resultAssertion.hasSingleOutput().hasSingleEntry(name, value);
    }

    public DmnDecisionResultAssertion hasEmptyResult() {
        this.isNotNull();
        return this.hasResult().isEmpty();
    }

    public <T extends Exception> ThrowableAssert thrown(Class<T> expectedException) {
        this.isNotNull();
        if (this.decision == null) {
            this.failWithMessage("Expected decision not to be null.", new Object[0]);
        }
        try {
            ((DmnEngine)this.actual).evaluate(this.decision, this.variables);
            this.failWithMessage("<%s> expected but no exception was thrown", new Object[]{expectedException.getName()});
        }
        catch (Exception e) {
            if (expectedException.isInstance(e)) {
                return (ThrowableAssert)Assertions.assertThat((Throwable)e);
            }
            this.failWithMessage("<%s> expected but was <%s>", new Object[]{expectedException, e.getClass()});
        }
        return null;
    }
}

