/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.dmn.engine.DmnDecisionRuleResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationListener;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedDecisionRule;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedInput;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedOutput;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionRuleResultImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableInputImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableOutputImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableResultImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableRuleImpl;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.delegate.DmnDecisionTableEvaluationEventImpl;
import org.camunda.bpm.dmn.engine.impl.delegate.DmnEvaluatedDecisionRuleImpl;
import org.camunda.bpm.dmn.engine.impl.delegate.DmnEvaluatedInputImpl;
import org.camunda.bpm.dmn.engine.impl.delegate.DmnEvaluatedOutputImpl;
import org.camunda.bpm.dmn.engine.impl.el.VariableContextScriptBindings;
import org.camunda.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElExpression;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.camunda.bpm.dmn.feel.impl.FeelEngine;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.bpm.engine.variable.impl.context.CompositeVariableContext;
import org.camunda.bpm.engine.variable.impl.context.SingleVariableContext;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.commons.utils.StringUtil;

public class DefaultDmnDecisionContext {
    protected static final DmnEngineLogger LOG = DmnEngineLogger.ENGINE_LOGGER;
    protected final List<DmnDecisionTableEvaluationListener> evaluationListeners;
    protected final DmnScriptEngineResolver scriptEngineResolver;
    protected final ElProvider elProvider;
    protected final FeelEngine feelEngine;
    protected final String inputExpressionExpressionLanguage;
    protected final String inputEntryExpressionLanguage;
    protected final String outputEntryExpressionLanguage;

    public DefaultDmnDecisionContext(DefaultDmnEngineConfiguration configuration) {
        this.evaluationListeners = configuration.getDecisionTableEvaluationListeners();
        this.scriptEngineResolver = configuration.getScriptEngineResolver();
        this.elProvider = configuration.getElProvider();
        this.feelEngine = configuration.getFeelEngine();
        this.inputExpressionExpressionLanguage = configuration.getDefaultInputExpressionExpressionLanguage();
        this.inputEntryExpressionLanguage = configuration.getDefaultInputEntryExpressionLanguage();
        this.outputEntryExpressionLanguage = configuration.getDefaultOutputEntryExpressionLanguage();
    }

    public DmnDecisionTableResult evaluateDecisionTable(DmnDecisionTableImpl decisionTable, VariableContext variableContext) {
        DmnDecisionTableEvaluationEventImpl evaluationResult = new DmnDecisionTableEvaluationEventImpl();
        evaluationResult.setDecisionTable(decisionTable);
        evaluationResult.setExecutedDecisionElements(this.calculateExecutedDecisionElements(decisionTable));
        int inputSize = decisionTable.getInputs().size();
        List<DmnDecisionTableRuleImpl> matchingRules = new ArrayList<DmnDecisionTableRuleImpl>(decisionTable.getRules());
        for (int inputIdx = 0; inputIdx < inputSize; ++inputIdx) {
            DmnDecisionTableInputImpl input = decisionTable.getInputs().get(inputIdx);
            DmnEvaluatedInput evaluatedInput = this.evaluateInput(input, variableContext);
            evaluationResult.getInputs().add(evaluatedInput);
            VariableContext localVariableContext = this.getLocalVariableContext(input, evaluatedInput, variableContext);
            matchingRules = this.evaluateInputForAvailableRules(inputIdx, input, matchingRules, localVariableContext);
        }
        this.setEvaluationOutput(decisionTable, matchingRules, variableContext, evaluationResult);
        return this.generateDecisionTableResult(decisionTable, evaluationResult);
    }

    protected DmnEvaluatedInput evaluateInput(DmnDecisionTableInputImpl input, VariableContext variableContext) {
        DmnEvaluatedInputImpl evaluatedInput = new DmnEvaluatedInputImpl(input);
        DmnExpressionImpl expression = input.getExpression();
        if (expression != null) {
            Object value = this.evaluateInputExpression(expression, variableContext);
            TypedValue typedValue = expression.getTypeDefinition().transform(value);
            evaluatedInput.setValue(typedValue);
        } else {
            evaluatedInput.setValue(Variables.untypedNullValue());
        }
        return evaluatedInput;
    }

    protected List<DmnDecisionTableRuleImpl> evaluateInputForAvailableRules(int conditionIdx, DmnDecisionTableInputImpl input, List<DmnDecisionTableRuleImpl> availableRules, VariableContext variableContext) {
        ArrayList<DmnDecisionTableRuleImpl> matchingRules = new ArrayList<DmnDecisionTableRuleImpl>();
        for (DmnDecisionTableRuleImpl availableRule : availableRules) {
            DmnExpressionImpl condition = availableRule.getConditions().get(conditionIdx);
            if (!this.isConditionApplicable(input, condition, variableContext)) continue;
            matchingRules.add(availableRule);
        }
        return matchingRules;
    }

    private VariableContext getLocalVariableContext(DmnDecisionTableInputImpl input, DmnEvaluatedInput evaluatedInput, VariableContext variableContext) {
        if (this.isNonEmptyExpression(input.getExpression())) {
            return CompositeVariableContext.compose((VariableContext[])new VariableContext[]{SingleVariableContext.singleVariable((String)evaluatedInput.getInputVariable(), (TypedValue)evaluatedInput.getValue()), variableContext});
        }
        return variableContext;
    }

    protected boolean isConditionApplicable(DmnDecisionTableInputImpl input, DmnExpressionImpl condition, VariableContext variableContext) {
        Object result = this.evaluateInputEntry(input, condition, variableContext);
        return result != null && result.equals(true);
    }

    protected void setEvaluationOutput(DmnDecisionTableImpl decisionTable, List<DmnDecisionTableRuleImpl> matchingRules, VariableContext variableContext, DmnDecisionTableEvaluationEventImpl evaluationResult) {
        List<DmnDecisionTableOutputImpl> decisionTableOutputs = decisionTable.getOutputs();
        ArrayList<DmnEvaluatedDecisionRule> evaluatedDecisionRules = new ArrayList<DmnEvaluatedDecisionRule>();
        for (DmnDecisionTableRuleImpl matchingRule : matchingRules) {
            DmnEvaluatedDecisionRule evaluatedRule = this.evaluateMatchingRule(decisionTableOutputs, matchingRule, variableContext);
            evaluatedDecisionRules.add(evaluatedRule);
        }
        evaluationResult.setMatchingRules(evaluatedDecisionRules);
    }

    protected DmnEvaluatedDecisionRule evaluateMatchingRule(List<DmnDecisionTableOutputImpl> decisionTableOutputs, DmnDecisionTableRuleImpl matchingRule, VariableContext variableContext) {
        DmnEvaluatedDecisionRuleImpl evaluatedDecisionRule = new DmnEvaluatedDecisionRuleImpl(matchingRule);
        Map<String, DmnEvaluatedOutput> outputEntries = this.evaluateOutputEntries(decisionTableOutputs, matchingRule, variableContext);
        evaluatedDecisionRule.setOutputEntries(outputEntries);
        return evaluatedDecisionRule;
    }

    protected DmnDecisionTableResult generateDecisionTableResult(DmnDecisionTableImpl decisionTable, DmnDecisionTableEvaluationEventImpl evaluationResult) {
        DmnDecisionTableEvaluationEvent evaluationEvent = decisionTable.getHitPolicyHandler().apply(evaluationResult);
        for (DmnDecisionTableEvaluationListener evaluationListener : this.evaluationListeners) {
            evaluationListener.notify(evaluationEvent);
        }
        return this.generateDecisionTableResult(evaluationEvent);
    }

    protected DmnDecisionTableResult generateDecisionTableResult(DmnDecisionTableEvaluationEvent evaluationResult) {
        ArrayList<DmnDecisionRuleResult> ruleResults = new ArrayList<DmnDecisionRuleResult>();
        if (evaluationResult.getCollectResultName() != null || evaluationResult.getCollectResultValue() != null) {
            DmnDecisionRuleResultImpl ruleResult = new DmnDecisionRuleResultImpl();
            ruleResult.putValue(evaluationResult.getCollectResultName(), evaluationResult.getCollectResultValue());
            ruleResults.add(ruleResult);
        } else {
            for (DmnEvaluatedDecisionRule evaluatedRule : evaluationResult.getMatchingRules()) {
                DmnDecisionRuleResultImpl ruleResult = new DmnDecisionRuleResultImpl();
                for (DmnEvaluatedOutput evaluatedOutput : evaluatedRule.getOutputEntries().values()) {
                    ruleResult.putValue(evaluatedOutput.getOutputName(), evaluatedOutput.getValue());
                }
                ruleResults.add(ruleResult);
            }
        }
        return new DmnDecisionTableResultImpl(ruleResults);
    }

    protected long calculateExecutedDecisionElements(DmnDecisionTableImpl decisionTable) {
        return (decisionTable.getInputs().size() + decisionTable.getOutputs().size()) * decisionTable.getRules().size();
    }

    protected Object evaluateInputExpression(DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionLanguage = expression.getExpressionLanguage();
        if (expressionLanguage == null) {
            expressionLanguage = this.inputExpressionExpressionLanguage;
        }
        if (this.isFeelExpressionLanguage(expressionLanguage)) {
            return this.evaluateFeelSimpleExpression(expression, variableContext);
        }
        return this.evaluateExpression(expressionLanguage, expression, variableContext);
    }

    private Object evaluateInputEntry(DmnDecisionTableInputImpl input, DmnExpressionImpl condition, VariableContext variableContext) {
        if (this.isNonEmptyExpression(condition)) {
            String expressionLanguage = condition.getExpressionLanguage();
            if (expressionLanguage == null) {
                expressionLanguage = this.inputEntryExpressionLanguage;
            }
            if (this.isFeelExpressionLanguage(expressionLanguage)) {
                return this.evaluateFeelSimpleUnaryTests(input, condition, variableContext);
            }
            return this.evaluateExpression(expressionLanguage, condition, variableContext);
        }
        return true;
    }

    protected Map<String, DmnEvaluatedOutput> evaluateOutputEntries(List<DmnDecisionTableOutputImpl> decisionTableOutputs, DmnDecisionTableRuleImpl matchingRule, VariableContext variableContext) {
        LinkedHashMap<String, DmnEvaluatedOutput> outputEntries = new LinkedHashMap<String, DmnEvaluatedOutput>();
        for (int outputIdx = 0; outputIdx < decisionTableOutputs.size(); ++outputIdx) {
            DmnExpressionImpl conclusion = matchingRule.getConclusions().get(outputIdx);
            if (!this.isNonEmptyExpression(conclusion)) continue;
            Object value = this.evaluateOutputEntry(conclusion, variableContext);
            DmnDecisionTableOutputImpl decisionTableOutput = decisionTableOutputs.get(outputIdx);
            TypedValue typedValue = decisionTableOutput.getTypeDefinition().transform(value);
            DmnEvaluatedOutputImpl evaluatedOutput = new DmnEvaluatedOutputImpl(decisionTableOutput, typedValue);
            outputEntries.put(decisionTableOutput.getOutputName(), evaluatedOutput);
        }
        return outputEntries;
    }

    protected Object evaluateOutputEntry(DmnExpressionImpl conclusion, VariableContext variableContext) {
        String expressionLanguage = conclusion.getExpressionLanguage();
        if (expressionLanguage == null) {
            expressionLanguage = this.outputEntryExpressionLanguage;
        }
        if (this.isFeelExpressionLanguage(expressionLanguage)) {
            return this.evaluateFeelSimpleExpression(conclusion, variableContext);
        }
        return this.evaluateExpression(expressionLanguage, conclusion, variableContext);
    }

    protected TypedValue evaluateFeelSimpleExpression(DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionText = expression.getExpression();
        if (expressionText != null) {
            return (TypedValue)this.feelEngine.evaluateSimpleExpression(expressionText, variableContext);
        }
        return null;
    }

    protected Object evaluateFeelSimpleUnaryTests(DmnDecisionTableInputImpl input, DmnExpressionImpl condition, VariableContext variableContext) {
        String expressionText = condition.getExpression();
        if (expressionText != null) {
            return this.feelEngine.evaluateSimpleUnaryTests(expressionText, input.getInputVariable(), variableContext);
        }
        return null;
    }

    protected Object evaluateExpression(String expressionLanguage, DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionText = this.getExpressionTextForLanguage(expression, expressionLanguage);
        if (expressionText != null) {
            if (this.isElExpression(expressionLanguage)) {
                return this.evaluateElExpression(expressionLanguage, expressionText, variableContext);
            }
            return this.evaluateScriptExpression(expressionLanguage, variableContext, expressionText);
        }
        return null;
    }

    private Object evaluateScriptExpression(String expressionLanguage, VariableContext variableContext, String expressionText) {
        ScriptEngine scriptEngine = this.getScriptEngineForName(expressionLanguage);
        VariableContextScriptBindings bindings = VariableContextScriptBindings.wrap(scriptEngine.createBindings(), variableContext);
        bindings.put("variableContext", (Object)variableContext);
        try {
            return scriptEngine.eval(expressionText, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw LOG.unableToEvaluateExpression(expressionText, scriptEngine.getFactory().getLanguageName(), e);
        }
    }

    private Object evaluateElExpression(String expressionLanguage, String expressionText, VariableContext variableContext) {
        ElExpression elExpression = this.elProvider.createExpression(expressionText);
        try {
            return elExpression.getValue(variableContext);
        }
        catch (Exception e) {
            throw LOG.unableToEvaluateExpression(expressionText, expressionLanguage, e);
        }
    }

    protected String getExpressionTextForLanguage(DmnExpressionImpl expression, String expressionLanguage) {
        String expressionText = expression.getExpression();
        if (expressionText != null) {
            if ("juel".equals(expressionLanguage) && !StringUtil.isExpression((String)expressionText)) {
                return "${" + expressionText + "}";
            }
            return expressionText;
        }
        return null;
    }

    protected ScriptEngine getScriptEngineForName(String expressionLanguage) {
        EnsureUtil.ensureNotNull((String)"expressionLanguage", (Object)expressionLanguage);
        ScriptEngine scriptEngine = this.scriptEngineResolver.getScriptEngineForLanguage(expressionLanguage);
        if (scriptEngine != null) {
            return scriptEngine;
        }
        throw LOG.noScriptEngineFoundForLanguage(expressionLanguage);
    }

    protected boolean isElExpression(String expressionLanguage) {
        return "juel".equals(expressionLanguage);
    }

    protected boolean isNonEmptyExpression(DmnExpressionImpl expression) {
        return expression != null && expression.getExpression() != null && !expression.getExpression().trim().isEmpty();
    }

    protected boolean isFeelExpressionLanguage(String expressionLanguage) {
        EnsureUtil.ensureNotNull((String)"expressionLanguage", (Object)expressionLanguage);
        return expressionLanguage.equals("http://www.omg.org/spec/FEEL/20140401") || expressionLanguage.toLowerCase().equals("feel");
    }
}

