/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionLogic;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionEvaluationListener;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionLogicEvaluationEvent;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionLiteralExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.delegate.DmnDecisionEvaluationEventImpl;
import org.camunda.bpm.dmn.engine.impl.evaluation.DecisionLiteralExpressionEvaluationHandler;
import org.camunda.bpm.dmn.engine.impl.evaluation.DecisionTableEvaluationHandler;
import org.camunda.bpm.dmn.engine.impl.evaluation.DmnDecisionLogicEvaluationHandler;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.context.VariableContext;

public class DefaultDmnDecisionContext {
    protected static final DmnEngineLogger LOG = DmnEngineLogger.ENGINE_LOGGER;
    protected final List<DmnDecisionEvaluationListener> evaluationListeners;
    protected final Map<Class<? extends DmnDecisionLogic>, DmnDecisionLogicEvaluationHandler> evaluationHandlers;

    public DefaultDmnDecisionContext(DefaultDmnEngineConfiguration configuration) {
        this.evaluationListeners = configuration.getDecisionEvaluationListeners();
        this.evaluationHandlers = new HashMap<Class<? extends DmnDecisionLogic>, DmnDecisionLogicEvaluationHandler>();
        this.evaluationHandlers.put(DmnDecisionTableImpl.class, new DecisionTableEvaluationHandler(configuration));
        this.evaluationHandlers.put(DmnDecisionLiteralExpressionImpl.class, new DecisionLiteralExpressionEvaluationHandler(configuration));
    }

    public DmnDecisionResult evaluateDecision(DmnDecision decision, VariableContext variableContext) {
        if (decision.getKey() == null) {
            throw LOG.unableToFindAnyDecisionTable();
        }
        VariableMap variableMap = this.buildVariableMapFromVariableContext(variableContext);
        ArrayList<DmnDecision> requiredDecisions = new ArrayList<DmnDecision>();
        this.buildDecisionTree(decision, requiredDecisions);
        ArrayList<DmnDecisionLogicEvaluationEvent> evaluatedEvents = new ArrayList<DmnDecisionLogicEvaluationEvent>();
        DmnDecisionResult evaluatedResult = null;
        for (DmnDecision evaluateDecision : requiredDecisions) {
            DmnDecisionLogicEvaluationHandler handler = this.getDecisionEvaluationHandler(evaluateDecision);
            DmnDecisionLogicEvaluationEvent evaluatedEvent = handler.evaluate(evaluateDecision, variableMap.asVariableContext());
            evaluatedEvents.add(evaluatedEvent);
            evaluatedResult = handler.generateDecisionResult(evaluatedEvent);
            if (decision == evaluateDecision) continue;
            this.addResultToVariableContext(evaluatedResult, variableMap);
        }
        this.generateDecisionEvaluationEvent(evaluatedEvents);
        return evaluatedResult;
    }

    protected VariableMap buildVariableMapFromVariableContext(VariableContext variableContext) {
        VariableMap variableMap = Variables.createVariables();
        Set variables = variableContext.keySet();
        for (String variable : variables) {
            variableMap.put((Object)variable, (Object)variableContext.resolve(variable));
        }
        return variableMap;
    }

    protected void buildDecisionTree(DmnDecision decision, List<DmnDecision> requiredDecisions) {
        if (requiredDecisions.contains(decision)) {
            return;
        }
        for (DmnDecision dmnDecision : decision.getRequiredDecisions()) {
            this.buildDecisionTree(dmnDecision, requiredDecisions);
        }
        requiredDecisions.add(decision);
    }

    protected DmnDecisionLogicEvaluationHandler getDecisionEvaluationHandler(DmnDecision decision) {
        Class<?> key = decision.getDecisionLogic().getClass();
        if (this.evaluationHandlers.containsKey(key)) {
            return this.evaluationHandlers.get(key);
        }
        throw LOG.decisionLogicTypeNotSupported(decision.getDecisionLogic());
    }

    protected void addResultToVariableContext(DmnDecisionResult evaluatedResult, VariableMap variableMap) {
        List<Map<String, Object>> resultList = evaluatedResult.getResultList();
        if (resultList.isEmpty()) {
            return;
        }
        if (resultList.size() == 1) {
            variableMap.putAll((Map)evaluatedResult.getSingleResult());
        } else {
            HashSet<String> outputs = new HashSet<String>();
            for (Map<String, Object> resultMap : resultList) {
                outputs.addAll(resultMap.keySet());
            }
            for (String output : outputs) {
                List values = evaluatedResult.collectEntries(output);
                variableMap.put((Object)output, values);
            }
        }
    }

    protected void generateDecisionEvaluationEvent(List<DmnDecisionLogicEvaluationEvent> evaluatedEvents) {
        DmnDecisionLogicEvaluationEvent rootEvaluatedEvent = null;
        DmnDecisionEvaluationEventImpl decisionEvaluationEvent = new DmnDecisionEvaluationEventImpl();
        long executedDecisionElements = 0L;
        for (DmnDecisionLogicEvaluationEvent evaluatedEvent : evaluatedEvents) {
            executedDecisionElements += evaluatedEvent.getExecutedDecisionElements();
            rootEvaluatedEvent = evaluatedEvent;
        }
        decisionEvaluationEvent.setDecisionResult(rootEvaluatedEvent);
        decisionEvaluationEvent.setExecutedDecisionElements(executedDecisionElements);
        evaluatedEvents.remove(rootEvaluatedEvent);
        decisionEvaluationEvent.setRequiredDecisionResults(evaluatedEvents);
        for (DmnDecisionEvaluationListener evaluationListener : this.evaluationListeners) {
            evaluationListener.notify(decisionEvaluationEvent);
        }
    }
}

