/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.evaluation;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.el.VariableContextScriptBindings;
import org.camunda.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElExpression;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.camunda.bpm.dmn.feel.impl.FeelEngine;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.commons.utils.StringUtil;

public class ExpressionEvaluationHandler {
    protected static final DmnEngineLogger LOG = DmnEngineLogger.ENGINE_LOGGER;
    protected final DmnScriptEngineResolver scriptEngineResolver;
    protected final ElProvider elProvider;
    protected final FeelEngine feelEngine;

    public ExpressionEvaluationHandler(DefaultDmnEngineConfiguration configuration) {
        this.scriptEngineResolver = configuration.getScriptEngineResolver();
        this.elProvider = configuration.getElProvider();
        this.feelEngine = configuration.getFeelEngine();
    }

    public Object evaluateExpression(String expressionLanguage, DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionText = this.getExpressionTextForLanguage(expression, expressionLanguage);
        if (expressionText != null) {
            if (this.isFeelExpressionLanguage(expressionLanguage)) {
                return this.evaluateFeelSimpleExpression(expressionText, variableContext);
            }
            if (this.isElExpression(expressionLanguage)) {
                return this.evaluateElExpression(expressionLanguage, expressionText, variableContext);
            }
            return this.evaluateScriptExpression(expressionLanguage, variableContext, expressionText);
        }
        return null;
    }

    protected Object evaluateScriptExpression(String expressionLanguage, VariableContext variableContext, String expressionText) {
        ScriptEngine scriptEngine = this.getScriptEngineForName(expressionLanguage);
        VariableContextScriptBindings bindings = VariableContextScriptBindings.wrap(scriptEngine.createBindings(), variableContext);
        bindings.put("variableContext", (Object)variableContext);
        try {
            return scriptEngine.eval(expressionText, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw LOG.unableToEvaluateExpression(expressionText, scriptEngine.getFactory().getLanguageName(), e);
        }
    }

    protected Object evaluateElExpression(String expressionLanguage, String expressionText, VariableContext variableContext) {
        ElExpression elExpression = this.elProvider.createExpression(expressionText);
        try {
            return elExpression.getValue(variableContext);
        }
        catch (Exception e) {
            throw LOG.unableToEvaluateExpression(expressionText, expressionLanguage, e);
        }
    }

    protected TypedValue evaluateFeelSimpleExpression(String expressionText, VariableContext variableContext) {
        return (TypedValue)this.feelEngine.evaluateSimpleExpression(expressionText, variableContext);
    }

    protected String getExpressionTextForLanguage(DmnExpressionImpl expression, String expressionLanguage) {
        String expressionText = expression.getExpression();
        if (expressionText != null) {
            if ("juel".equals(expressionLanguage) && !StringUtil.isExpression((String)expressionText)) {
                return "${" + expressionText + "}";
            }
            return expressionText;
        }
        return null;
    }

    protected ScriptEngine getScriptEngineForName(String expressionLanguage) {
        EnsureUtil.ensureNotNull((String)"expressionLanguage", (Object)expressionLanguage);
        ScriptEngine scriptEngine = this.scriptEngineResolver.getScriptEngineForLanguage(expressionLanguage);
        if (scriptEngine != null) {
            return scriptEngine;
        }
        throw LOG.noScriptEngineFoundForLanguage(expressionLanguage);
    }

    protected boolean isElExpression(String expressionLanguage) {
        return "juel".equals(expressionLanguage);
    }

    public boolean isFeelExpressionLanguage(String expressionLanguage) {
        EnsureUtil.ensureNotNull((String)"expressionLanguage", (Object)expressionLanguage);
        return expressionLanguage.equals("http://www.omg.org/spec/FEEL/20140401") || expressionLanguage.toLowerCase().equals("feel");
    }
}

