/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.scriptengine;

import java.util.Map;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionModel;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.scriptengine.DmnScriptEngine;

public class DmnCompiledScript
extends CompiledScript {
    protected DmnScriptEngine dmnScriptEngine;
    protected DmnEngine dmnEngine;
    protected DmnDecisionModel dmnDecisionModel;
    protected DmnDecision dmnDecision;

    public DmnCompiledScript(DmnScriptEngine dmnScriptEngine, DmnDecisionModel dmnDecisionModel) {
        this.dmnScriptEngine = dmnScriptEngine;
        this.dmnEngine = dmnScriptEngine.getDmnEngine();
        this.dmnDecisionModel = dmnDecisionModel;
    }

    public DmnCompiledScript(DmnScriptEngine dmnScriptEngine, DmnDecision dmnDecision) {
        this.dmnScriptEngine = dmnScriptEngine;
        this.dmnEngine = dmnScriptEngine.getDmnEngine();
        this.dmnDecision = dmnDecision;
    }

    public DmnDecisionResult eval() throws ScriptException {
        return this.eval((String)null);
    }

    public DmnDecisionResult eval(String decisionKey) throws ScriptException {
        return this.eval(decisionKey, this.getEngine().getContext());
    }

    public DmnDecisionResult eval(Bindings bindings) throws ScriptException {
        return this.eval((String)null, bindings);
    }

    public DmnDecisionResult eval(String decisionKey, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.dmnScriptEngine.getScriptContext(bindings);
        return this.eval(decisionKey, scriptContext);
    }

    public DmnDecisionResult eval(ScriptContext context) throws ScriptException {
        Map<String, Object> variables = this.dmnScriptEngine.getVariables(context);
        String decisionKey = this.dmnScriptEngine.getDecisionKey(context);
        return this.eval(decisionKey, variables);
    }

    public DmnDecisionResult eval(String decisionKey, ScriptContext context) throws ScriptException {
        Map<String, Object> variables = this.dmnScriptEngine.getVariables(context);
        return this.eval(decisionKey, variables);
    }

    public DmnDecisionResult eval(Map<String, Object> variables) throws ScriptException {
        return this.eval((String)null, variables);
    }

    public DmnDecisionResult eval(String decisionKey, Map<String, Object> variables) throws ScriptException {
        DmnDecision decision = this.getDmnDecision(decisionKey);
        return this.eval(decision, variables);
    }

    public DmnDecisionResult eval(DmnDecision decision, Map<String, Object> variables) throws ScriptException {
        try {
            return this.dmnEngine.evaluate(decision, variables);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public ScriptEngine getEngine() {
        return this.dmnScriptEngine;
    }

    public DmnDecision getDmnDecision(String decisionKey) {
        if (this.dmnDecisionModel != null) {
            if (decisionKey != null) {
                return this.dmnDecisionModel.getDecision(decisionKey);
            }
            return (DmnDecision)this.dmnDecisionModel.getDecisions().get(0);
        }
        return this.dmnDecision;
    }
}

