/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.scriptengine;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionModel;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DmnEngineConfigurationImpl;
import org.camunda.bpm.dmn.scriptengine.DmnCompiledScript;
import org.camunda.bpm.dmn.scriptengine.DmnScriptEngineFactory;
import org.camunda.commons.utils.IoUtil;

public class DmnScriptEngine
extends AbstractScriptEngine
implements Compilable {
    public static final String DECISION_ID_ATTRIBUTE = "decisionKey";
    protected ScriptEngineFactory scriptEngineFactory;
    protected DmnEngine dmnEngine;

    public DmnScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public DmnScriptEngine(DmnEngine dmnEngine) {
        this(null, dmnEngine);
    }

    public DmnScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
        this.dmnEngine = new DmnEngineConfigurationImpl().buildEngine();
    }

    public DmnScriptEngine(ScriptEngineFactory scriptEngineFactory, DmnEngine dmnEngine) {
        this.scriptEngineFactory = scriptEngineFactory;
        this.dmnEngine = dmnEngine;
    }

    public DmnEngine getDmnEngine() {
        return this.dmnEngine;
    }

    public void setDmnEngine(DmnEngine dmnEngine) {
        this.dmnEngine = dmnEngine;
    }

    public void setDmnEngine(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngine = dmnEngineConfiguration.buildEngine();
    }

    @Override
    public DmnCompiledScript compile(String script) throws ScriptException {
        DmnDecisionModel dmnDecisionModel = this.parseDmnDecisionModel(script);
        return new DmnCompiledScript(this, dmnDecisionModel);
    }

    @Override
    public DmnCompiledScript compile(Reader reader) throws ScriptException {
        String script = this.getScriptFromReader(reader);
        return this.compile(script);
    }

    public DmnCompiledScript compile(DmnDecision decision) throws ScriptException {
        return new DmnCompiledScript(this, decision);
    }

    public DmnDecisionResult eval(String script) throws ScriptException {
        return this.eval(script, (String)null);
    }

    public DmnDecisionResult eval(String script, String decisionKey) throws ScriptException {
        return this.eval(script, decisionKey, this.context);
    }

    public DmnDecisionResult eval(String script, Bindings bindings) throws ScriptException {
        return this.eval(script, null, bindings);
    }

    public DmnDecisionResult eval(String script, String decisionKey, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.getScriptContext(bindings);
        return this.eval(script, decisionKey, scriptContext);
    }

    public DmnDecisionResult eval(String script, ScriptContext context) throws ScriptException {
        String decisionKey = this.getDecisionKey(context);
        return this.eval(script, decisionKey, context);
    }

    public DmnDecisionResult eval(String script, String decisionKey, ScriptContext context) throws ScriptException {
        Map<String, Object> variables = this.getVariables(context);
        DmnDecisionModel dmnDecisionModel = this.parseDmnDecisionModel(script);
        DmnDecision decision = decisionKey != null ? dmnDecisionModel.getDecision(decisionKey) : (DmnDecision)dmnDecisionModel.getDecisions().get(0);
        try {
            return this.dmnEngine.evaluate(decision, variables);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public DmnDecisionResult eval(Reader reader) throws ScriptException {
        return this.eval(reader, (String)null);
    }

    public DmnDecisionResult eval(Reader reader, String decisionKey) throws ScriptException {
        return this.eval(reader, decisionKey, this.context);
    }

    public DmnDecisionResult eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(reader, null, bindings);
    }

    public DmnDecisionResult eval(Reader reader, String decisionKey, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.getScriptContext(bindings);
        return this.eval(reader, decisionKey, scriptContext);
    }

    public DmnDecisionResult eval(Reader reader, ScriptContext context) throws ScriptException {
        String decisionKey = this.getDecisionKey(context);
        return this.eval(reader, decisionKey, context);
    }

    public DmnDecisionResult eval(Reader reader, String decisionKey, ScriptContext context) throws ScriptException {
        String script = this.getScriptFromReader(reader);
        return this.eval(script, decisionKey, context);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        if (this.scriptEngineFactory == null) {
            DmnScriptEngine dmnScriptEngine = this;
            synchronized (dmnScriptEngine) {
                if (this.scriptEngineFactory == null) {
                    this.scriptEngineFactory = new DmnScriptEngineFactory();
                }
            }
        }
        return this.scriptEngineFactory;
    }

    protected String getScriptFromReader(Reader reader) {
        return IoUtil.readerAsString((Reader)reader);
    }

    protected DmnDecisionModel parseDmnDecisionModel(String script) {
        InputStream inputStream = IoUtil.stringAsInputStream((String)script);
        return this.dmnEngine.parseDecisionModel(inputStream);
    }

    protected Map<String, Object> getVariables(ScriptContext context) {
        Integer[] scopes;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Integer scope : scopes = new Integer[]{200, 100}) {
            Bindings bindings = context.getBindings(scope);
            variables.putAll(bindings);
        }
        return variables;
    }

    protected String getDecisionKey(ScriptContext context) {
        String decisionKey = null;
        if (context != null) {
            decisionKey = (String)this.getScriptContextAttribute(context, DECISION_ID_ATTRIBUTE);
        }
        return decisionKey;
    }

    @Override
    protected ScriptContext getScriptContext(Bindings bindings) {
        return super.getScriptContext(bindings);
    }

    protected Object getScriptContextAttribute(ScriptContext context, String name) {
        Object attribute = context.getAttribute(name);
        if (attribute == null) {
            attribute = this.getContext().getAttribute(name);
        }
        return attribute;
    }
}

