/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.scriptengine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.scriptengine.DmnScriptEngine;

public class DmnScriptEngineFactory
implements ScriptEngineFactory {
    public static final String NAME = "dmn";
    public static final String VERSION = "1.0";
    public static final List<String> names = Collections.unmodifiableList(Arrays.asList("dmn", "Dmn", "DMN"));
    public static final List<String> extensions = Collections.unmodifiableList(Arrays.asList("dmn", "dmn10.xml"));
    public static final List<String> mimeTypes = Collections.emptyList();
    protected DmnEngine dmnEngine;

    public DmnScriptEngineFactory() {
    }

    public DmnScriptEngineFactory(DmnEngine dmnEngine) {
        this.dmnEngine = dmnEngine;
    }

    @Override
    public String getEngineName() {
        return NAME;
    }

    @Override
    public String getEngineVersion() {
        return VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getLanguageName() {
        return NAME;
    }

    @Override
    public String getLanguageVersion() {
        return VERSION;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        throw new UnsupportedOperationException("getMethodCallSyntax");
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        throw new UnsupportedOperationException("getOutputStatement");
    }

    @Override
    public String getProgram(String ... statements) {
        throw new UnsupportedOperationException("getProgram");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        if (this.dmnEngine != null) {
            return new DmnScriptEngine(this, this.dmnEngine);
        }
        return new DmnScriptEngine();
    }
}

