/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.juel;

import de.odysseus.el.ExpressionFactoryImpl;
import java.io.Reader;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.camunda.bpm.dmn.juel.JuelCompiledScript;
import org.camunda.bpm.dmn.juel.JuelScriptElContext;
import org.camunda.bpm.dmn.juel.JuelScriptEngineFactory;
import org.camunda.commons.utils.IoUtil;

public class JuelScriptEngine
extends AbstractScriptEngine
implements Compilable {
    public static final String EL_CONTEXT_ATTRIBUTE = "elContext";
    protected ScriptEngineFactory scriptEngineFactory;
    protected ExpressionFactoryImpl expressionFactory;

    public JuelScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public JuelScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
        this.expressionFactory = new ExpressionFactoryImpl();
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        ValueExpression expression = this.createExpression(script, this.context);
        return new JuelCompiledScript(this, expression);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        String script = IoUtil.readerAsString((Reader)reader);
        return this.compile(script);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        ValueExpression expression = this.createExpression(script, context);
        return this.evaluateExpression(expression, context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        String script = IoUtil.readerAsString((Reader)reader);
        return this.eval(script, context);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JuelScriptEngine juelScriptEngine = this;
        synchronized (juelScriptEngine) {
            if (this.scriptEngineFactory == null) {
                this.scriptEngineFactory = new JuelScriptEngineFactory();
            }
        }
        return this.scriptEngineFactory;
    }

    public ELContext createElContext(ScriptContext context) {
        ELContext elContext;
        Object elContextAttribute = context.getAttribute(EL_CONTEXT_ATTRIBUTE);
        if (elContextAttribute instanceof ELContext) {
            elContext = (ELContext)elContextAttribute;
        } else {
            elContext = new JuelScriptElContext(context, (ExpressionFactory)this.expressionFactory);
            context.setAttribute(EL_CONTEXT_ATTRIBUTE, elContext, 100);
        }
        return elContext;
    }

    public ValueExpression createExpression(String expression, ScriptContext context) throws ScriptException {
        ELContext elContext = this.createElContext(context);
        try {
            return this.expressionFactory.createValueExpression(elContext, expression, Object.class);
        }
        catch (ELException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public Object evaluateExpression(ValueExpression expression, ScriptContext context) throws ScriptException {
        ELContext elContext = this.createElContext(context);
        try {
            return expression.getValue(elContext);
        }
        catch (ELException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }
}

