/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.juel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.camunda.bpm.dmn.juel.JuelScriptEngine;
import org.camunda.commons.utils.StringUtil;

public class JuelScriptEngineFactory
implements ScriptEngineFactory {
    public static final String NAME = "juel";
    public static final String VERSION = "2.2.7";
    public static final List<String> names = Collections.unmodifiableList(Arrays.asList("juel", "Juel", "JUEL"));
    public static final List<String> extensions = Collections.unmodifiableList(Collections.singletonList("juel"));
    public static final List<String> mimeTypes = Collections.emptyList();

    @Override
    public String getEngineName() {
        return NAME;
    }

    @Override
    public String getEngineVersion() {
        return VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getLanguageName() {
        return NAME;
    }

    @Override
    public String getLanguageVersion() {
        return VERSION;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String object, String method, String ... args) {
        return "${" + object + "." + method + "(" + StringUtil.join((String)", ", (String[])args) + ")}";
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        toDisplay = toDisplay.replace("\"", "\\\"").replace("\\", "\\\\");
        return "out:print(\"" + toDisplay + "\")";
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder builder = new StringBuilder();
        for (String statement : statements) {
            builder.append("${").append(statement).append("} ");
        }
        return builder.toString().trim();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new JuelScriptEngine(this);
    }
}

