/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.cfg;

import com.datastax.driver.core.AtomicMonotonicTimestampGenerator;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TimestampGenerator;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSessionFactory;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;

public class CassandraProcessEngineConfiguration
extends StandaloneProcessEngineConfiguration {
    public static final String DEFAULT_KEYSPACE = "camunda";
    protected String cassandraContactPoint;
    protected Cluster cluster;
    protected Session session;
    protected String keyspace;
    protected int jobShardSizeHours = 1;
    protected int jobShardInitNumber = 10;
    protected int replicationFactor = 1;

    protected void init() {
        this.initCassandraClient();
        super.init();
    }

    protected void initPersistenceProviders() {
        this.addSessionFactory(new CassandraPersistenceSessionFactory(this.session));
    }

    protected void initCassandraClient() {
        if (this.keyspace == null) {
            this.keyspace = DEFAULT_KEYSPACE;
        }
        if (this.cluster == null) {
            this.cluster = Cluster.builder().addContactPoint(this.cassandraContactPoint).withTimestampGenerator((TimestampGenerator)new AtomicMonotonicTimestampGenerator()).build();
            KeyspaceMetadata existingKeyspace = this.cluster.getMetadata().getKeyspace(DEFAULT_KEYSPACE);
            if (existingKeyspace == null) {
                Session session = this.cluster.connect();
                session.execute(String.format("CREATE keyspace %s WITH REPLICATION = { 'class' : 'SimpleStrategy', 'replication_factor' : " + this.replicationFactor + " };", this.keyspace));
                session.close();
            }
            this.session = this.cluster.connect(this.keyspace);
        }
    }

    public ProcessEngine buildProcessEngine() {
        super.buildProcessEngine();
        CassandraPersistenceSession.staticInit(this);
        return this.processEngine;
    }

    protected void initIdGenerator() {
        if (this.idGenerator == null) {
            this.idGenerator = new StrongUuidGenerator();
        }
    }

    protected void initSqlSessionFactory() {
    }

    protected void initDataSource() {
    }

    protected void initJpa() {
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getCassandraContactPoint() {
        return this.cassandraContactPoint;
    }

    public CassandraProcessEngineConfiguration setCassandraContactPoint(String cassandraContactPoint) {
        this.cassandraContactPoint = cassandraContactPoint;
        return this;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public CassandraProcessEngineConfiguration setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public CassandraProcessEngineConfiguration setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public int getJobShardSizeHours() {
        return this.jobShardSizeHours;
    }

    public void setJobShardSizeHours(int jobShardSizeHours) {
        this.jobShardSizeHours = jobShardSizeHours;
    }

    public int getJobShardInitNumber() {
        return this.jobShardInitNumber;
    }

    public void setJobShardInitNumber(int jobShardInitNumber) {
        this.jobShardInitNumber = jobShardInitNumber;
    }
}

