/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Statement;
import org.camunda.bpm.engine.impl.db.DbEntity;

public abstract class LockedBatch<T extends DbEntity> {
    protected T entity;
    protected BatchStatement batch = new BatchStatement();
    protected BatchStatement indexBatch = null;
    protected String version = null;
    protected boolean shouldNotLock = false;

    public LockedBatch(T entity) {
        this.entity = entity;
    }

    public BatchStatement getBatch() {
        if (!this.shouldNotLock && !this.isEmpty()) {
            this.addLockStatement(this.batch);
        }
        return this.batch;
    }

    public boolean isEmpty() {
        return this.batch.getStatements().isEmpty();
    }

    protected abstract void addLockStatement(BatchStatement var1);

    public void addStatement(Statement statement) {
        this.batch.add(statement);
    }

    public void addIndexStatement(Statement statement) {
        if (this.indexBatch == null) {
            this.indexBatch = new BatchStatement();
        }
        this.indexBatch.add(statement);
    }

    public void setShouldNotLock() {
        this.shouldNotLock = true;
    }

    public BatchStatement getIndexBatch() {
        return this.indexBatch;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

