/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.indexes;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexUtils;
import org.camunda.bpm.engine.impl.db.DbEntity;

public abstract class AbstractIndexHandler<T extends DbEntity>
implements IndexHandler<T> {
    private static final Logger LOG = Logger.getLogger(AbstractIndexHandler.class.getName());
    private static PreparedStatement insertStatement = null;
    private static PreparedStatement deleteStatement = null;
    private static PreparedStatement deleteUniqueStatement = null;
    private static PreparedStatement selectStatement = null;

    protected abstract String getIndexName();

    protected abstract String getIndexValue(T var1);

    protected abstract String getValue(T var1);

    @Override
    public String getUniqueValue(Map<String, Object> params, CassandraPersistenceSession cassandraPersistenceSession, String ... indexValues) {
        if (!this.isUnique()) {
            throw new UnsupportedOperationException("Index " + this.getIndexName() + " is not unique.");
        }
        Session s = cassandraPersistenceSession.getSession();
        List rows = s.execute((Statement)selectStatement.bind(new Object[]{this.getIndexName(), this.getIndexValue(indexValues)})).all();
        if (rows == null || rows.size() == 0) {
            return null;
        }
        if (rows.size() > 1) {
            LOG.warning("Multiple values found for a unique index " + this.getIndexName() + ", indexValue=" + indexValues[0]);
        }
        return ((Row)rows.get(0)).getString("val");
    }

    @Override
    public List<String> getValues(Map<String, Object> params, CassandraPersistenceSession cassandraPersistenceSession, String ... indexValues) {
        Session s = cassandraPersistenceSession.getSession();
        List rows = s.execute((Statement)selectStatement.bind(new Object[]{this.getIndexName(), this.getIndexValue(indexValues)})).all();
        ArrayList<String> result = new ArrayList<String>();
        for (Row row : rows) {
            result.add(row.getString("val"));
        }
        return result;
    }

    @Override
    public Statement getInsertStatement(CassandraPersistenceSession cassandraPersistenceSession, T entity) {
        String indexValue = this.getIndexValue(entity);
        String value = this.getValue(entity);
        if (indexValue == null || value == null) {
            return null;
        }
        return insertStatement.bind(new Object[]{this.getIndexName(), this.getIndexValue(entity), this.getValue(entity)});
    }

    @Override
    public Statement getDeleteStatement(CassandraPersistenceSession cassandraPersistenceSession, T entity) {
        String indexValue = this.getIndexValue(entity);
        if (indexValue == null) {
            return null;
        }
        if (this.isUnique()) {
            return deleteUniqueStatement.bind(new Object[]{this.getIndexName(), indexValue});
        }
        String value = this.getValue(entity);
        if (value == null) {
            return null;
        }
        return deleteStatement.bind(new Object[]{this.getIndexName(), indexValue, value});
    }

    @Override
    public List<Statement> getUpdateStatements(CassandraPersistenceSession cassandraPersistenceSession, T entity, T oldEntity) {
        if (!this.checkIndexMatch(oldEntity, entity)) {
            return Arrays.asList(this.getDeleteStatement(cassandraPersistenceSession, oldEntity), this.getInsertStatement(cassandraPersistenceSession, entity));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean checkIndexMatch(T entity, String ... indexValues) {
        return this.getIndexValue(entity).equals(this.getIndexValue(indexValues));
    }

    @Override
    public boolean checkIndexMatch(T entity, T newEntity) {
        return this.getIndexValue(entity).equals(this.getIndexValue(newEntity));
    }

    protected String getIndexValue(String ... indexValues) {
        if (indexValues.length > 1) {
            throw new IllegalArgumentException("This index supports only one index value.");
        }
        return IndexUtils.createIndexValue(indexValues);
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
        selectStatement = config.getSession().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"val"}).from("cam_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"idx_value", (Object)QueryBuilder.bindMarker())));
        insertStatement = config.getSession().prepare((RegularStatement)QueryBuilder.insertInto((String)"cam_index").value("idx_name", (Object)QueryBuilder.bindMarker()).value("idx_value", (Object)QueryBuilder.bindMarker()).value("val", (Object)QueryBuilder.bindMarker()));
        deleteStatement = config.getSession().prepare((RegularStatement)QueryBuilder.delete().all().from("cam_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"idx_value", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"val", (Object)QueryBuilder.bindMarker())));
        deleteUniqueStatement = config.getSession().prepare((RegularStatement)QueryBuilder.delete().all().from("cam_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"idx_value", (Object)QueryBuilder.bindMarker())));
    }
}

