/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.indexes;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.impl.db.DbEntity;

public abstract class AbstractOrderedIndexHandler<T extends DbEntity>
implements IndexHandler<T> {
    private static final Logger LOG = Logger.getLogger(AbstractOrderedIndexHandler.class.getName());
    private static PreparedStatement insertStatement = null;
    private static PreparedStatement deleteStatement = null;
    private static PreparedStatement deleteUniqueStatement = null;
    private static PreparedStatement selectStatement = null;
    private static PreparedStatement selectLessThanStatement = null;
    private static PreparedStatement selectGreaterThanStatement = null;
    private static PreparedStatement selectBetweenStatement = null;

    protected abstract String getIndexName();

    protected abstract String getPartitionId(T var1);

    protected abstract Date getOrderBy(T var1);

    protected abstract String getValue(T var1);

    public static void prepare(CassandraProcessEngineConfiguration config) {
        selectLessThanStatement = config.getSession().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"val"}).from("cam_ordered_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"part_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.lt((String)"order_by", (Object)QueryBuilder.bindMarker())));
        selectGreaterThanStatement = config.getSession().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"val"}).from("cam_ordered_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"part_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.gt((String)"order_by", (Object)QueryBuilder.bindMarker())));
        selectBetweenStatement = config.getSession().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"val"}).from("cam_ordered_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"part_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.gt((String)"order_by", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.lt((String)"order_by", (Object)QueryBuilder.bindMarker())));
        selectStatement = config.getSession().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"val"}).from("cam_ordered_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"part_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"order_by", (Object)QueryBuilder.bindMarker())));
        insertStatement = config.getSession().prepare((RegularStatement)QueryBuilder.insertInto((String)"cam_ordered_index").value("idx_name", (Object)QueryBuilder.bindMarker()).value("part_id", (Object)QueryBuilder.bindMarker()).value("order_by", (Object)QueryBuilder.bindMarker()).value("val", (Object)QueryBuilder.bindMarker()));
        deleteStatement = config.getSession().prepare((RegularStatement)QueryBuilder.delete().all().from("cam_ordered_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"part_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"order_by", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"val", (Object)QueryBuilder.bindMarker())));
        deleteUniqueStatement = config.getSession().prepare((RegularStatement)QueryBuilder.delete().all().from("cam_ordered_index").where(QueryBuilder.eq((String)"idx_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"part_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"order_by", (Object)QueryBuilder.bindMarker())));
    }

    @Override
    public Statement getInsertStatement(CassandraPersistenceSession cassandraPersistenceSession, T entity) {
        String value = this.getValue(entity);
        if (value == null) {
            return null;
        }
        return insertStatement.bind(new Object[]{this.getIndexName(), this.getPartitionId(entity), this.getOrderBy(entity), this.getValue(entity)});
    }

    @Override
    public Statement getDeleteStatement(CassandraPersistenceSession cassandraPersistenceSession, T entity) {
        if (this.isUnique()) {
            return deleteUniqueStatement.bind(new Object[]{this.getIndexName(), this.getPartitionId(entity), this.getOrderBy(entity)});
        }
        String value = this.getValue(entity);
        if (value == null) {
            return null;
        }
        return deleteStatement.bind(new Object[]{this.getIndexName(), this.getPartitionId(entity), this.getOrderBy(entity), value});
    }

    @Override
    public List<Statement> getUpdateStatements(CassandraPersistenceSession cassandraPersistenceSession, T entity, T oldEntity) {
        if (!this.checkIndexMatch(oldEntity, entity)) {
            return Arrays.asList(this.getDeleteStatement(cassandraPersistenceSession, oldEntity), this.getInsertStatement(cassandraPersistenceSession, entity));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean checkIndexMatch(T entity, T newEntity) {
        return this.getPartitionId(entity).equals(this.getPartitionId(newEntity)) && (this.getOrderBy(entity) == null && this.getOrderBy(newEntity) == null || this.getOrderBy(entity) != null && this.getOrderBy(entity).equals(this.getOrderBy(newEntity)));
    }

    @Override
    public String getUniqueValue(Map<String, Object> params, CassandraPersistenceSession cassandraPersistenceSession, String ... indexValues) {
        if (!this.isUnique()) {
            throw new UnsupportedOperationException("Index " + this.getIndexName() + " is not unique.");
        }
        if (params == null || !params.containsKey("part_id") || !params.containsKey("order_by")) {
            throw new IllegalArgumentException("Partition ID and ordering value is required for ordered index " + this.getIndexName());
        }
        Session s = cassandraPersistenceSession.getSession();
        String partId = (String)params.get("part_id");
        Date orderBy = (Date)params.get("order_by");
        List rows = s.execute((Statement)selectStatement.bind(new Object[]{this.getIndexName(), partId, orderBy})).all();
        if (rows == null || rows.size() == 0) {
            return null;
        }
        if (rows.size() > 1) {
            LOG.warning("Multiple values found for a unique index " + this.getIndexName());
        }
        return ((Row)rows.get(0)).getString("val");
    }

    @Override
    public List<String> getValues(Map<String, Object> params, CassandraPersistenceSession cassandraPersistenceSession, String ... indexValues) {
        if (params == null || !params.containsKey("part_id") || !params.containsKey("order_by") && !params.containsKey("start") && !params.containsKey("end")) {
            throw new IllegalArgumentException("Partition ID and ordering value is required for ordered index " + this.getIndexName());
        }
        Session s = cassandraPersistenceSession.getSession();
        String partId = (String)params.get("part_id");
        Date orderBy = (Date)params.get("order_by");
        Date start = (Date)params.get("start");
        Date end = (Date)params.get("end");
        List rows = null;
        if (orderBy != null) {
            rows = s.execute((Statement)selectStatement.bind(new Object[]{this.getIndexName(), partId, orderBy})).all();
        } else if (start != null && end != null) {
            rows = s.execute((Statement)selectBetweenStatement.bind(new Object[]{this.getIndexName(), partId, start, end})).all();
        } else if (start != null) {
            rows = s.execute((Statement)selectGreaterThanStatement.bind(new Object[]{this.getIndexName(), partId, start})).all();
        } else if (end != null) {
            rows = s.execute((Statement)selectLessThanStatement.bind(new Object[]{this.getIndexName(), partId, end})).all();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Row row : rows) {
            result.add(row.getString("val"));
        }
        return result;
    }
}

