/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.BatchStatement;
import java.util.List;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.JobDefinitionIdByProcessDefinitionIdIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.BulkOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.operation.JobDefinitionOperations;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;

public class BulkDeleteJobDefinitionsByProcessDefinitionId
implements BulkOperationHandler {
    @Override
    public void perform(CassandraPersistenceSession session, Object parameter, BatchStatement flush) {
        String procDefId = (String)parameter;
        IndexHandler<JobDefinitionEntity> index = JobDefinitionOperations.getIndexHandler(JobDefinitionIdByProcessDefinitionIdIndex.class);
        List<String> ids = index.getValues(null, session, procDefId);
        JobDefinitionOperations ops = (JobDefinitionOperations)session.getOperationsHandler(JobDefinitionEntity.class);
        for (String jobDefId : ids) {
            JobDefinitionEntity def = session.selectById(JobDefinitionEntity.class, jobDefId);
            ops.delete(session, def, flush);
        }
    }
}

