/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExecutionIdByEventTypeAndNameIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.ProcessIdByEventSubscriptionIdIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.EntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.operation.LoadedCompositeEntity;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.cassandra.provider.type.UDTypeHandler;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;

public class EventSubscriptionOperations
implements EntityOperationHandler<EventSubscriptionEntity> {
    protected static Map<Class<?>, IndexHandler<EventSubscriptionEntity>> indexHandlers = new HashMap();

    public EventSubscriptionOperations(CassandraPersistenceSession cassandraPersistenceSession) {
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
    }

    @Override
    public void insert(CassandraPersistenceSession session, EventSubscriptionEntity entity) {
        session.addStatement(this.createUpdateStatement(session, entity));
        for (IndexHandler<EventSubscriptionEntity> index : indexHandlers.values()) {
            session.addStatement(index.getInsertStatement(session, entity));
        }
    }

    @Override
    public void delete(CassandraPersistenceSession session, EventSubscriptionEntity entity) {
        session.addStatement((Statement)QueryBuilder.delete().mapElt("event_subscriptions", (Object)entity.getId()).from("cam_proc_inst").where(QueryBuilder.eq((String)"id", (Object)entity.getProcessInstanceId())), entity.getProcessInstanceId());
        for (IndexHandler<EventSubscriptionEntity> index : indexHandlers.values()) {
            session.addIndexStatement(index.getDeleteStatement(session, entity), entity.getProcessInstanceId());
        }
    }

    @Override
    public void update(CassandraPersistenceSession session, EventSubscriptionEntity entity) {
        session.addStatement(this.createUpdateStatement(session, entity), entity.getProcessInstanceId());
        for (IndexHandler<EventSubscriptionEntity> index : indexHandlers.values()) {
            session.addIndexStatement(index.getInsertStatement(session, entity), entity.getProcessInstanceId());
        }
    }

    protected Statement createUpdateStatement(CassandraPersistenceSession session, EventSubscriptionEntity entity) {
        Session s = session.getSession();
        UDTypeHandler typeHander = session.getTypeHander(EventSubscriptionEntity.class);
        CassandraSerializer<EventSubscriptionEntity> serializer = CassandraPersistenceSession.getSerializer(EventSubscriptionEntity.class);
        UDTValue value = typeHander.createValue(s);
        serializer.write((SettableData<?>)value, entity);
        return QueryBuilder.update((String)"cam_proc_inst").with(QueryBuilder.put((String)"event_subscriptions", (Object)entity.getId(), (Object)value)).where(QueryBuilder.eq((String)"id", (Object)entity.getProcessInstanceId()));
    }

    @Override
    public EventSubscriptionEntity getEntityById(CassandraPersistenceSession session, String id) {
        String procId = indexHandlers.get(ProcessIdByEventSubscriptionIdIndex.class).getUniqueValue(null, session, id);
        if (procId == null) {
            return null;
        }
        LoadedCompositeEntity loadedCompostite = session.selectCompositeById("process-instance-compostite", procId);
        if (loadedCompostite == null) {
            return null;
        }
        return (EventSubscriptionEntity)loadedCompostite.get("event_subscriptions").get(id);
    }

    public static IndexHandler<EventSubscriptionEntity> getIndexHandler(Class<?> type) {
        return indexHandlers.get(type);
    }

    static {
        indexHandlers.put(ExecutionIdByEventTypeAndNameIndex.class, new ExecutionIdByEventTypeAndNameIndex());
        indexHandlers.put(ProcessIdByEventSubscriptionIdIndex.class, new ProcessIdByEventSubscriptionIdIndex());
    }
}

