/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.JobDefinitionIdByProcessDefinitionIdIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.AbstractEntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;

public class JobDefinitionOperations
extends AbstractEntityOperationHandler<JobDefinitionEntity> {
    private static final String INSERT = "INSERT into cam_job_def (id, proc_def_id, proc_def_key, act_id, type, config, priority, suspension_state, revision ) values (?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String DELETE = "DELETE FROM cam_job_def WHERE id = ?;";
    private static PreparedStatement insertStatement = null;
    private static PreparedStatement deleteStatement = null;
    protected static Map<Class<?>, IndexHandler<JobDefinitionEntity>> indexHandlers = new HashMap();

    public JobDefinitionOperations(CassandraPersistenceSession cassandraPersistenceSession) {
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
        insertStatement = config.getSession().prepare(INSERT);
        deleteStatement = config.getSession().prepare(DELETE);
    }

    @Override
    public void insert(CassandraPersistenceSession session, JobDefinitionEntity entity) {
        CassandraSerializer<JobDefinitionEntity> serializer = CassandraPersistenceSession.getSerializer(JobDefinitionEntity.class);
        BoundStatement statement = insertStatement.bind();
        serializer.write((SettableData<?>)statement, entity);
        session.addStatement((Statement)statement);
        for (IndexHandler<JobDefinitionEntity> index : indexHandlers.values()) {
            session.addStatement(index.getInsertStatement(session, entity));
        }
    }

    @Override
    public void delete(CassandraPersistenceSession session, JobDefinitionEntity entity) {
        session.addStatement((Statement)deleteStatement.bind(new Object[]{entity.getId()}));
        for (IndexHandler<JobDefinitionEntity> index : indexHandlers.values()) {
            session.addStatement(index.getDeleteStatement(session, entity));
        }
    }

    public void delete(CassandraPersistenceSession session, JobDefinitionEntity entity, BatchStatement flush) {
        flush.add((Statement)deleteStatement.bind(new Object[]{entity.getId()}));
        for (IndexHandler<JobDefinitionEntity> index : indexHandlers.values()) {
            flush.add(index.getDeleteStatement(session, entity));
        }
    }

    @Override
    public void update(CassandraPersistenceSession session, JobDefinitionEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<JobDefinitionEntity> getEntityType() {
        return JobDefinitionEntity.class;
    }

    @Override
    protected String getTableName() {
        return "cam_job_def";
    }

    public static IndexHandler<JobDefinitionEntity> getIndexHandler(Class<?> type) {
        return indexHandlers.get(type);
    }

    static {
        indexHandlers.put(JobDefinitionIdByProcessDefinitionIdIndex.class, new JobDefinitionIdByProcessDefinitionIdIndex());
    }
}

