/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExclusiveJobsByDueDateIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExclusiveJobsByLockExpiryIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.JobsByConfigurationIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.JobsByExecutionIdIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.AbstractEntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.cassandra.provider.table.JobEntityKey;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EntityLoadListener;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class JobOperations
extends AbstractEntityOperationHandler<JobEntity>
implements EntityLoadListener {
    private static final String INSERT = "INSERT into cam_job (id, type, due_date, lock_exp_time, lock_owner, exclusive, execution_id, process_instance_id, process_def_id, process_def_key, retries, exception_stack_id, exception_message, repeat, handler_type, handler_cfg, deployment_id, suspension_state, job_def_id, sequence_counter, priority, revision) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String DELETE = "DELETE FROM cam_job WHERE id = ?;";
    private static final String INSERT_INDEX = "INSERT into cam_job_idx (shard_id, is_locked, sort_time, id) values (?, ?, ?, ?);";
    private static final String DELETE_INDEX = "DELETE FROM cam_job_idx WHERE shard_id = ? AND is_locked = ? AND sort_time = ? AND id = ? ;";
    private static PreparedStatement insertStatement = null;
    private static PreparedStatement deleteStatement = null;
    private static PreparedStatement insertIndexStatement = null;
    private static PreparedStatement deleteIndexStatement = null;
    protected static int shardSizeMillis;
    protected static int shardInitNumber;
    protected static Map<Class<?>, IndexHandler<JobEntity>> indexHandlers;
    private Map<String, JobEntity> entityCache = new HashMap<String, JobEntity>();

    public JobOperations(CassandraPersistenceSession cassandraPersistenceSession) {
        cassandraPersistenceSession.addEntityLoadListener(this);
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
        insertStatement = config.getSession().prepare(INSERT);
        deleteStatement = config.getSession().prepare(DELETE);
        insertIndexStatement = config.getSession().prepare(INSERT_INDEX);
        deleteIndexStatement = config.getSession().prepare(DELETE_INDEX);
        shardSizeMillis = config.getJobShardSizeHours() * 3600 * 1000;
        shardInitNumber = config.getJobShardInitNumber();
    }

    @Override
    public void insert(CassandraPersistenceSession session, JobEntity entity) {
        if (entity.getDuedate() == null) {
            entity.setDuedate(new Date());
        }
        CassandraSerializer<JobEntity> serializer = CassandraPersistenceSession.getSerializer(JobEntity.class);
        BoundStatement statement = insertStatement.bind();
        serializer.write((SettableData<?>)statement, entity);
        session.addStatement((Statement)statement);
        this.insertIndex(session, entity);
        for (IndexHandler<JobEntity> index : indexHandlers.values()) {
            session.addStatement(index.getInsertStatement(session, entity));
        }
        this.entityCache.put(entity.getId(), entity);
    }

    protected void insertIndex(CassandraPersistenceSession session, JobEntity entity) {
        BoundStatement indStatement = insertIndexStatement.bind();
        this.bindKeyFields(session, entity, indStatement);
        session.addStatement((Statement)indStatement);
    }

    protected void bindKeyFields(CassandraPersistenceSession session, JobEntity entity, BoundStatement statement) {
        JobEntityKey key = new JobEntityKey(entity, shardSizeMillis);
        statement.setDate("shard_id", new Date(key.getShardId()));
        statement.setBool("is_locked", key.isLocked());
        statement.setDate("sort_time", new Date(key.getSortTime()));
        statement.setString("id", key.getId());
    }

    @Override
    public void delete(CassandraPersistenceSession session, JobEntity entity) {
        BoundStatement statement = deleteStatement.bind(new Object[]{entity.getId()});
        session.addStatement((Statement)statement);
        JobEntity oldEntity = this.getCachedEntity(entity);
        this.deleteIndex(session, oldEntity);
        for (IndexHandler<JobEntity> index : indexHandlers.values()) {
            session.addStatement(index.getDeleteStatement(session, oldEntity));
        }
    }

    protected void deleteIndex(CassandraPersistenceSession session, JobEntity entity) {
        BoundStatement indStatement = deleteIndexStatement.bind();
        this.bindKeyFields(session, entity, indStatement);
        session.addStatement((Statement)indStatement);
    }

    @Override
    public void update(CassandraPersistenceSession session, JobEntity entity) {
        JobEntityKey oldKey;
        JobEntityKey newKey;
        JobEntity oldEntity = this.getCachedEntity(entity);
        long now = System.currentTimeMillis();
        if (entity.getDuedate() == null) {
            entity.setDuedate(new Date(now));
        }
        if (!(newKey = new JobEntityKey(entity, shardSizeMillis)).equals(oldKey = new JobEntityKey(oldEntity, shardSizeMillis))) {
            if (newKey.isLocked()) {
                if (!entity.getLockExpirationTime().equals(oldEntity.getLockExpirationTime()) && entity.getLockExpirationTime().getTime() < now) {
                    entity.setLockExpirationTime(new Date(now));
                }
            } else if (!oldEntity.getDuedate().equals(entity.getDuedate()) && entity.getDuedate().getTime() < now) {
                entity.setDuedate(new Date(now));
            }
            this.deleteIndex(session, oldEntity);
        }
        this.insert(session, entity);
        for (IndexHandler<JobEntity> index : indexHandlers.values()) {
            for (Statement st : index.getUpdateStatements(session, entity, oldEntity)) {
                session.addStatement(st);
            }
        }
        this.entityCache.put(entity.getId(), entity);
    }

    public void onEntityLoaded(DbEntity entity) {
        if (entity instanceof JobEntity) {
            CassandraSerializer<JobEntity> serializer = CassandraPersistenceSession.getSerializer(JobEntity.class);
            JobEntity copy = serializer.copy((JobEntity)entity);
            this.entityCache.put(entity.getId(), copy);
        }
    }

    @Override
    protected Class<JobEntity> getEntityType() {
        return JobEntity.class;
    }

    @Override
    protected String getTableName() {
        return "cam_job";
    }

    private JobEntity getCachedEntity(JobEntity entity) {
        JobEntity oldEntity = this.entityCache.get(entity.getId());
        if (oldEntity == null) {
            throw new RuntimeException("Inconsistent state, entity needs to be loaded into command context before it can be updated.");
        }
        return oldEntity;
    }

    public static IndexHandler<JobEntity> getIndexHandler(Class<?> type) {
        return indexHandlers.get(type);
    }

    static {
        indexHandlers = new HashMap();
        indexHandlers.put(JobsByConfigurationIndex.class, new JobsByConfigurationIndex());
        indexHandlers.put(ExclusiveJobsByDueDateIndex.class, new ExclusiveJobsByDueDateIndex());
        indexHandlers.put(ExclusiveJobsByLockExpiryIndex.class, new ExclusiveJobsByLockExpiryIndex());
        indexHandlers.put(JobsByExecutionIdIndex.class, new JobsByExecutionIdIndex());
    }
}

