/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.operation.AbstractEntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class ProcessDefinitionOperations
extends AbstractEntityOperationHandler<ProcessDefinitionEntity> {
    private static final String INSERT = "INSERT into cam_proc_def (id, key, version, category, name, deployment_id, suspension_state) values (?, ?, ?, ?, ?, ?, ?);";
    private static final String DELETE = "DELETE FROM cam_proc_def WHERE id = '?';";
    private static final String INSERT_IDX_VERSION = "INSERT into cam_proc_def_idx_version (key, version, id) values (?, ?, ?);";
    private static final String DELETE_IDX_VERSION = "DELETE FROM cam_proc_def_idx_version WHERE key = '?' AND version = ?;";
    private static PreparedStatement insertStatement = null;
    private static PreparedStatement insertVersionIndexStatement = null;
    private static PreparedStatement deleteStatement = null;
    private static PreparedStatement deleteVersionIndexStatement = null;
    private static boolean isInitialized = false;
    protected static Map<Class<?>, IndexHandler<ProcessDefinitionEntity>> indexHandlers = new HashMap();

    public ProcessDefinitionOperations(CassandraPersistenceSession cassandraPersistenceSession) {
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
        insertStatement = config.getSession().prepare(INSERT);
        insertVersionIndexStatement = config.getSession().prepare(INSERT_IDX_VERSION);
        deleteStatement = config.getSession().prepare(DELETE);
        deleteVersionIndexStatement = config.getSession().prepare(DELETE_IDX_VERSION);
    }

    @Override
    public void insert(CassandraPersistenceSession session, ProcessDefinitionEntity entity) {
        Session s = session.getSession();
        CassandraSerializer<ProcessDefinitionEntity> serializer = CassandraPersistenceSession.getSerializer(ProcessDefinitionEntity.class);
        BoundStatement statement = insertStatement.bind();
        serializer.write((SettableData<?>)statement, entity);
        session.addStatement((Statement)statement);
        session.addStatement((Statement)insertVersionIndexStatement.bind(new Object[]{entity.getKey(), entity.getVersion(), entity.getId()}));
        for (IndexHandler<ProcessDefinitionEntity> index : indexHandlers.values()) {
            session.addStatement(index.getInsertStatement(session, entity));
        }
    }

    @Override
    public void delete(CassandraPersistenceSession session, ProcessDefinitionEntity entity) {
        session.addStatement((Statement)deleteStatement.bind(new Object[]{entity.getId()}));
        session.addStatement((Statement)deleteVersionIndexStatement.bind(new Object[]{entity.getKey(), entity.getVersion()}));
        for (IndexHandler<ProcessDefinitionEntity> index : indexHandlers.values()) {
            session.addStatement(index.getDeleteStatement(session, entity));
        }
    }

    @Override
    public void update(CassandraPersistenceSession session, ProcessDefinitionEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<ProcessDefinitionEntity> getEntityType() {
        return ProcessDefinitionEntity.class;
    }

    @Override
    protected String getTableName() {
        return "cam_proc_def";
    }

    public static IndexHandler<ProcessDefinitionEntity> getIndexHandler(Class<?> type) {
        return indexHandlers.get(type);
    }
}

