/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.operation.AbstractEntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class ResourceOperations
extends AbstractEntityOperationHandler<ResourceEntity> {
    protected static final String INSERT = "INSERT into cam_resource (id, name, deployment_id, content) values (?, ?, ?, ?);";

    public ResourceOperations(CassandraPersistenceSession cassandraPersistenceSession) {
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
    }

    @Override
    public void insert(CassandraPersistenceSession session, ResourceEntity entity) {
        Session s = session.getSession();
        CassandraSerializer<ResourceEntity> serializer = CassandraPersistenceSession.getSerializer(ResourceEntity.class);
        BoundStatement statement = s.prepare(INSERT).bind();
        serializer.write((SettableData<?>)statement, entity);
        session.addStatement((Statement)statement);
    }

    @Override
    public void delete(CassandraPersistenceSession session, ResourceEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(CassandraPersistenceSession session, ResourceEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<ResourceEntity> getEntityType() {
        return ResourceEntity.class;
    }

    @Override
    protected String getTableName() {
        return "cam_resource";
    }
}

