/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExecutionIdByVariableValueIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.ProcessIdByProcessVariableValueIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.ProcessIdByVariableIdIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.EntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.operation.LoadedCompositeEntity;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.cassandra.provider.type.UDTypeHandler;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EntityLoadListener;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;

public class VariableEntityOperations
implements EntityOperationHandler<VariableInstanceEntity>,
EntityLoadListener {
    protected static Map<Class<?>, IndexHandler<VariableInstanceEntity>> indexHandlers = new HashMap();
    private Map<String, VariableInstanceEntity> varValuesCache = new HashMap<String, VariableInstanceEntity>();

    public VariableEntityOperations(CassandraPersistenceSession cassandraPersistenceSession) {
        cassandraPersistenceSession.addEntityLoadListener(this);
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
    }

    @Override
    public void insert(CassandraPersistenceSession session, VariableInstanceEntity entity) {
        session.addStatement(this.createUpdateStatement(session, entity));
        for (IndexHandler<VariableInstanceEntity> index : indexHandlers.values()) {
            session.addStatement(index.getInsertStatement(session, entity));
        }
    }

    @Override
    public void delete(CassandraPersistenceSession session, VariableInstanceEntity entity) {
        session.addStatement((Statement)QueryBuilder.delete().mapElt("variables", (Object)entity.getId()).from("cam_proc_inst").where(QueryBuilder.eq((String)"id", (Object)entity.getProcessInstanceId())), entity.getProcessInstanceId());
        for (IndexHandler<VariableInstanceEntity> index : indexHandlers.values()) {
            session.addIndexStatement(index.getDeleteStatement(session, this.getCachedEntity(entity)), entity.getProcessInstanceId());
        }
    }

    @Override
    public void update(CassandraPersistenceSession session, VariableInstanceEntity entity) {
        session.addStatement(this.createUpdateStatement(session, entity), entity.getProcessInstanceId());
        VariableInstanceEntity oldEntity = this.getCachedEntity(entity);
        for (IndexHandler<VariableInstanceEntity> index : indexHandlers.values()) {
            for (Statement st : index.getUpdateStatements(session, entity, oldEntity)) {
                session.addIndexStatement(st, entity.getProcessInstanceId());
            }
        }
        this.updateVariableCache(entity);
    }

    protected Statement createUpdateStatement(CassandraPersistenceSession session, VariableInstanceEntity entity) {
        Session s = session.getSession();
        UDTypeHandler typeHandler = session.getTypeHander(VariableInstanceEntity.class);
        CassandraSerializer<VariableInstanceEntity> serializer = CassandraPersistenceSession.getSerializer(VariableInstanceEntity.class);
        UDTValue value = typeHandler.createValue(s);
        serializer.write((SettableData<?>)value, entity);
        return QueryBuilder.update((String)"cam_proc_inst").with(QueryBuilder.put((String)"variables", (Object)entity.getId(), (Object)value)).where(QueryBuilder.eq((String)"id", (Object)entity.getProcessInstanceId()));
    }

    @Override
    public VariableInstanceEntity getEntityById(CassandraPersistenceSession session, String id) {
        String procId = indexHandlers.get(ProcessIdByVariableIdIndex.class).getUniqueValue(null, session, id);
        if (procId == null) {
            return null;
        }
        LoadedCompositeEntity loadedComposite = session.selectCompositeById("process-instance-compostite", procId);
        if (loadedComposite == null) {
            return null;
        }
        return (VariableInstanceEntity)loadedComposite.get("variables").get(id);
    }

    public static IndexHandler<VariableInstanceEntity> getIndexHandler(Class<?> type) {
        return indexHandlers.get(type);
    }

    private void updateVariableCache(VariableInstanceEntity variable) {
        CassandraSerializer<VariableInstanceEntity> serializer = CassandraPersistenceSession.getSerializer(VariableInstanceEntity.class);
        VariableInstanceEntity copy = serializer.copy(variable);
        this.varValuesCache.put(variable.getId(), copy);
    }

    public void onEntityLoaded(DbEntity entity) {
        if (entity instanceof VariableInstanceEntity) {
            this.updateVariableCache((VariableInstanceEntity)entity);
        }
    }

    private VariableInstanceEntity getCachedEntity(VariableInstanceEntity entity) {
        VariableInstanceEntity oldEntity = this.varValuesCache.get(entity.getId());
        if (oldEntity == null) {
            throw new RuntimeException("Inconsistent state, entity needs to be loaded into command context before it can be updated.");
        }
        return oldEntity;
    }

    static {
        indexHandlers.put(ProcessIdByVariableIdIndex.class, new ProcessIdByVariableIdIndex());
        indexHandlers.put(ExecutionIdByVariableValueIndex.class, new ExecutionIdByVariableValueIndex());
        indexHandlers.put(ProcessIdByProcessVariableValueIndex.class, new ProcessIdByProcessVariableValueIndex());
    }
}

