/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExclusiveJobsByDueDateIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExclusiveJobsByLockExpiryIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.operation.JobOperations;
import org.camunda.bpm.engine.cassandra.provider.query.SelectListQueryHandler;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class SelectExclusiveJobsToExecute
implements SelectListQueryHandler<JobEntity, ListQueryParameterObject> {
    @Override
    public List<JobEntity> executeQuery(CassandraPersistenceSession session, ListQueryParameterObject query) {
        Map params = (Map)query.getParameter();
        Date now = (Date)params.get("now");
        String pid = (String)params.get("pid");
        IndexHandler<JobEntity> lockedIndex = JobOperations.getIndexHandler(ExclusiveJobsByLockExpiryIndex.class);
        IndexHandler<JobEntity> index = JobOperations.getIndexHandler(ExclusiveJobsByDueDateIndex.class);
        HashMap<String, Object> indexParams = new HashMap<String, Object>();
        indexParams.put("part_id", pid);
        indexParams.put("end", now);
        List<String> keys = lockedIndex.getValues(indexParams, session, new String[]{null});
        keys.addAll(index.getValues(indexParams, session, new String[]{null}));
        ArrayList<JobEntity> result = new ArrayList<JobEntity>();
        for (String keyStr : keys) {
            JobEntity job = session.selectById(JobEntity.class, keyStr);
            if (job == null) continue;
            result.add(job);
        }
        return result;
    }
}

