/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExecutionIdByEventTypeAndNameIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExecutionIdByProcessIdIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExecutionIdByVariableValueIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexUtils;
import org.camunda.bpm.engine.cassandra.provider.indexes.ProcessIdByBusinessKeyIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.ProcessIdByProcessVariableValueIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.EventSubscriptionOperations;
import org.camunda.bpm.engine.cassandra.provider.operation.ExecutionEntityOperations;
import org.camunda.bpm.engine.cassandra.provider.operation.LoadedCompositeEntity;
import org.camunda.bpm.engine.cassandra.provider.operation.VariableEntityOperations;
import org.camunda.bpm.engine.cassandra.provider.query.SelectListQueryHandler;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryValue;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.QueryVariableValue;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;

public class SelectExecutionsByQueryCriteria
implements SelectListQueryHandler<ExecutionEntity, ExecutionQueryImpl> {
    @Override
    public List<ExecutionEntity> executeQuery(CassandraPersistenceSession session, ExecutionQueryImpl executionQuery) {
        Map<String, Object> resultMap = new HashMap<String, ExecutionEntity>();
        if (executionQuery.getExecutionId() != null) {
            ExecutionEntity entity = session.selectById(ExecutionEntity.class, executionQuery.getExecutionId());
            if (entity == null) {
                return Collections.emptyList();
            }
            resultMap.put(entity.getId(), entity);
        }
        String queryProcessId = executionQuery.getProcessInstanceId();
        if (executionQuery.getBusinessKey() != null) {
            queryProcessId = ExecutionEntityOperations.getIndexHandler(ProcessIdByBusinessKeyIndex.class).getUniqueValue(null, session, executionQuery.getBusinessKey());
            if (executionQuery.getProcessInstanceId() != null && queryProcessId != executionQuery.getProcessInstanceId()) {
                return Collections.emptyList();
            }
        }
        if (queryProcessId != null) {
            if (!resultMap.isEmpty()) {
                for (ExecutionEntity obj : resultMap.values()) {
                    if (obj.getProcessInstanceId().equals(queryProcessId)) continue;
                    return Collections.emptyList();
                }
            } else {
                LoadedCompositeEntity loadedProcessInstance = session.selectCompositeById("process-instance-compostite", queryProcessId);
                if (loadedProcessInstance != null) {
                    resultMap = loadedProcessInstance.get("executions");
                }
                if (resultMap.isEmpty()) {
                    return Collections.emptyList();
                }
            }
        }
        if (!resultMap.isEmpty()) {
            return this.filter(resultMap, session, executionQuery);
        }
        Set<String> executionIdSet = null;
        if (executionQuery.getQueryVariableValues() != null && !executionQuery.getQueryVariableValues().isEmpty() && ((executionIdSet = this.getIdsByVariables(session, executionQuery.getQueryVariableValues(), executionIdSet)) == null || executionIdSet.isEmpty())) {
            return Collections.emptyList();
        }
        if (!(executionIdSet != null && !executionIdSet.isEmpty() || executionQuery.getEventSubscriptions() == null || executionQuery.getEventSubscriptions().isEmpty() || (executionIdSet = this.getIdsByEventSubscriptions(session, executionQuery.getEventSubscriptions(), executionIdSet)) != null && !executionIdSet.isEmpty())) {
            return Collections.emptyList();
        }
        if (executionIdSet == null || executionIdSet.isEmpty()) {
            return Collections.emptyList();
        }
        for (String id : executionIdSet) {
            ExecutionEntity entity = session.selectById(ExecutionEntity.class, id);
            if (entity == null) continue;
            resultMap.put(id, entity);
        }
        if (!resultMap.isEmpty()) {
            return this.filter(resultMap, session, executionQuery);
        }
        return new ArrayList<Object>(resultMap.values());
    }

    protected Set<String> getIdsByVariables(CassandraPersistenceSession session, List<QueryVariableValue> queryVariables, Set<String> executionIdSet) {
        ExecutionIdByVariableValueIndex allExecutionsIndex = (ExecutionIdByVariableValueIndex)VariableEntityOperations.getIndexHandler(ExecutionIdByVariableValueIndex.class);
        for (QueryVariableValue queryVariableValue : queryVariables) {
            if (queryVariableValue.isLocal()) {
                List<String> queriedExecutionIds = allExecutionsIndex.getValuesByTypedValue(session, queryVariableValue.getName(), queryVariableValue.getTypedValue());
                if (queriedExecutionIds.isEmpty()) {
                    return null;
                }
                executionIdSet = executionIdSet == null ? new HashSet<String>(queriedExecutionIds) : IndexUtils.crossCheckIndexes(executionIdSet, new HashSet<String>(queriedExecutionIds));
            } else {
                executionIdSet = this.getIdsByProcessVariable(session, queryVariableValue, executionIdSet);
            }
            if (!executionIdSet.isEmpty()) continue;
            return null;
        }
        return executionIdSet;
    }

    protected Set<String> getIdsByProcessVariable(CassandraPersistenceSession session, QueryVariableValue queryVariable, Set<String> executionIdSet) {
        ProcessIdByProcessVariableValueIndex processIdIndex = (ProcessIdByProcessVariableValueIndex)VariableEntityOperations.getIndexHandler(ProcessIdByProcessVariableValueIndex.class);
        ExecutionIdByProcessIdIndex processExecutionsIndex = (ExecutionIdByProcessIdIndex)ExecutionEntityOperations.getIndexHandler(ExecutionIdByProcessIdIndex.class);
        List<String> queriedProcessIds = processIdIndex.getValuesByTypedValue(session, queryVariable.getName(), queryVariable.getTypedValue());
        for (String processId : queriedProcessIds) {
            List<String> queriedExecutionIds = processExecutionsIndex.getValues(null, session, processId);
            if (queriedExecutionIds.isEmpty()) {
                return Collections.emptySet();
            }
            if (!(executionIdSet = executionIdSet == null ? new HashSet<String>(queriedExecutionIds) : IndexUtils.crossCheckIndexes(executionIdSet, new HashSet<String>(queriedExecutionIds))).isEmpty()) continue;
            return executionIdSet;
        }
        return executionIdSet;
    }

    protected Set<String> getIdsByEventSubscriptions(CassandraPersistenceSession session, List<EventSubscriptionQueryValue> eventSubscriptions, Set<String> executionIdSet) {
        ExecutionIdByEventTypeAndNameIndex index = (ExecutionIdByEventTypeAndNameIndex)EventSubscriptionOperations.getIndexHandler(ExecutionIdByEventTypeAndNameIndex.class);
        for (EventSubscriptionQueryValue queryEvent : eventSubscriptions) {
            if (queryEvent.getEventName() == null) continue;
            List<String> queriedExecutionIds = index.getValues(null, session, queryEvent.getEventType(), queryEvent.getEventName());
            if (queriedExecutionIds.isEmpty()) {
                return null;
            }
            if (!(executionIdSet = executionIdSet == null ? new HashSet<String>(queriedExecutionIds) : IndexUtils.crossCheckIndexes(executionIdSet, new HashSet<String>(queriedExecutionIds))).isEmpty()) continue;
            return null;
        }
        return executionIdSet;
    }

    protected List<ExecutionEntity> filter(Map<String, ExecutionEntity> resultMap, CassandraPersistenceSession session, ExecutionQueryImpl executionQuery) {
        if (resultMap.isEmpty()) {
            throw new IllegalArgumentException("Do not filter empty resultMap.");
        }
        if (executionQuery.getQueryVariableValues() != null && !executionQuery.getQueryVariableValues().isEmpty()) {
            this.filterByVariables(executionQuery.getQueryVariableValues(), resultMap, session);
        }
        if (executionQuery.getEventSubscriptions() != null && !executionQuery.getEventSubscriptions().isEmpty()) {
            this.filterByEventSubscriptions(executionQuery.getEventSubscriptions(), resultMap, session);
        }
        if (resultMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ExecutionEntity>(resultMap.values());
    }

    protected void filterByEventSubscriptions(List<EventSubscriptionQueryValue> eventSubscriptions, Map<String, ExecutionEntity> resultMap, CassandraPersistenceSession session) {
        HashSet<String> filteredExecutionIds = new HashSet<String>();
        block0: for (ExecutionEntity executionEntity : resultMap.values()) {
            for (EventSubscriptionQueryValue queriedEventSubscription : eventSubscriptions) {
                boolean found = false;
                for (EventSubscriptionEntity eventSubscriptionEntity : executionEntity.getEventSubscriptions()) {
                    if (!queriedEventSubscription.getEventType().equals(eventSubscriptionEntity.getEventType()) || queriedEventSubscription.getEventName() != null && !queriedEventSubscription.getEventName().equals(eventSubscriptionEntity.getEventName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                filteredExecutionIds.add(executionEntity.getId());
                continue block0;
            }
        }
        for (String filteredExecution : filteredExecutionIds) {
            resultMap.remove(filteredExecution);
        }
    }

    protected void filterByVariables(List<QueryVariableValue> variables, Map<String, ExecutionEntity> resultMap, CassandraPersistenceSession session) {
        HashSet<String> toRemove = new HashSet<String>();
        block0: for (ExecutionEntity executionEntity : resultMap.values()) {
            for (QueryVariableValue queryVariable : variables) {
                Object var = null;
                if (queryVariable.isLocal()) {
                    var = executionEntity.getVariableLocal(queryVariable.getName());
                } else {
                    LoadedCompositeEntity loadedProcessInstance = session.selectCompositeById("process-instance-compostite", executionEntity.getProcessInstanceId());
                    Collection<? extends DbEntity> processVariables = loadedProcessInstance.get("variables").values();
                    for (VariableInstanceEntity variableInstanceEntity : processVariables) {
                        if (!variableInstanceEntity.getName().equals(queryVariable.getName())) continue;
                        var = variableInstanceEntity.getValue();
                    }
                }
                if (var != null && var.equals(queryVariable.getValue())) continue;
                toRemove.add(executionEntity.getId());
                continue block0;
            }
        }
        for (String id : toRemove) {
            resultMap.remove(id);
        }
    }
}

