/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.query;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.JobsByExecutionIdIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.JobOperations;
import org.camunda.bpm.engine.cassandra.provider.query.SelectListQueryHandler;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class SelectJobsByExecutionId
implements SelectListQueryHandler<JobEntity, ListQueryParameterObject> {
    @Override
    public List<JobEntity> executeQuery(CassandraPersistenceSession session, ListQueryParameterObject query) {
        String executionId = (String)query.getParameter();
        IndexHandler<JobEntity> index = JobOperations.getIndexHandler(JobsByExecutionIdIndex.class);
        List<String> keys = index.getValues(null, session, executionId);
        ArrayList<JobEntity> result = new ArrayList<JobEntity>();
        for (String key : keys) {
            JobEntity job = session.selectById(JobEntity.class, key);
            if (job == null) continue;
            result.add(job);
        }
        return result;
    }
}

