/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.serializer;

import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;

public class VariableEntitySerializer
implements CassandraSerializer<VariableInstanceEntity> {
    @Override
    public void write(SettableData<?> data, VariableInstanceEntity entity) {
        data.setString("id", entity.getId()).setString("type", entity.getSerializerName()).setString("name", entity.getName()).setString("execution_id", entity.getExecutionId()).setString("proc_inst_id", entity.getProcessInstanceId()).setString("case_execution_id", entity.getCaseExecutionId()).setString("case_inst_id", entity.getCaseInstanceId()).setString("task_id", entity.getTaskId()).setString("bytearray_id", entity.getByteArrayValueId()).setString("text", entity.getTextValue()).setString("text2", entity.getTextValue2()).setLong("sequence_counter", entity.getSequenceCounter()).setBool("is_concurrent_local", entity.isConcurrentLocal());
        if (entity.getDoubleValue() != null) {
            data.setDouble("double", entity.getDoubleValue().doubleValue());
        } else {
            data.setToNull("double");
        }
        if (entity.getLongValue() != null) {
            data.setLong("long", entity.getLongValue().longValue());
        } else {
            data.setToNull("long");
        }
    }

    @Override
    public VariableInstanceEntity read(GettableData data) {
        VariableInstanceEntity entity = new VariableInstanceEntity();
        entity.setId(data.getString("id"));
        entity.setSerializerName(data.getString("type"));
        entity.setName(data.getString("name"));
        entity.setExecutionId(data.getString("execution_id"));
        entity.setProcessInstanceId(data.getString("proc_inst_id"));
        entity.setCaseExecutionId(data.getString("case_execution_id"));
        entity.setCaseInstanceId(data.getString("case_inst_id"));
        entity.setTaskId(data.getString("task_id"));
        entity.setByteArrayValueId(data.getString("bytearray_id"));
        if (!data.isNull("double")) {
            entity.setDoubleValue(Double.valueOf(data.getDouble("double")));
        }
        if (!data.isNull("long")) {
            entity.setLongValue(Long.valueOf(data.getLong("long")));
        }
        entity.setTextValue(data.getString("text"));
        entity.setTextValue2(data.getString("text2"));
        entity.setSequenceCounter(data.getLong("sequence_counter"));
        entity.setConcurrentLocal(data.getBool("is_concurrent_local"));
        return entity;
    }

    @Override
    public VariableInstanceEntity copy(VariableInstanceEntity data) {
        VariableInstanceEntity entity = new VariableInstanceEntity();
        entity.setId(data.getId());
        entity.setSerializerName(data.getSerializerName());
        entity.setName(data.getName());
        entity.setExecutionId(data.getExecutionId());
        entity.setProcessInstanceId(data.getProcessInstanceId());
        entity.setCaseExecutionId(data.getCaseExecutionId());
        entity.setCaseInstanceId(data.getCaseInstanceId());
        entity.setTaskId(data.getTaskId());
        entity.setByteArrayValueId(data.getByteArrayValueId());
        entity.setDoubleValue(data.getDoubleValue());
        entity.setLongValue(data.getLongValue());
        entity.setTextValue(data.getTextValue());
        entity.setTextValue2(data.getTextValue2());
        entity.setSequenceCounter(data.getSequenceCounter());
        entity.setConcurrentLocal(data.isConcurrentLocal());
        return entity;
    }
}

