/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.table;

import org.camunda.bpm.engine.cassandra.provider.indexes.IndexUtils;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public class JobEntityKey {
    private long shardId;
    private boolean isLocked;
    private long sortTime;
    private String id;

    public JobEntityKey(JobEntity entity, int shardSizeMillis) {
        this.isLocked = entity.getLockExpirationTime() != null;
        this.shardId = IndexUtils.calculateShard(this.isLocked ? entity.getLockExpirationTime().getTime() : entity.getDuedate().getTime(), shardSizeMillis);
        this.sortTime = this.isLocked ? entity.getLockExpirationTime().getTime() : entity.getDuedate().getTime();
        this.id = entity.getId();
    }

    public JobEntityKey(long shardId, boolean isLocked, long sortTime, String id) {
        this.shardId = shardId;
        this.isLocked = isLocked;
        this.sortTime = sortTime;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobEntityKey)) {
            return false;
        }
        JobEntityKey other = (JobEntityKey)obj;
        return this.shardId == other.shardId && this.isLocked == other.isLocked && this.sortTime == other.sortTime && (this.id == null && other.id == null || this.id != null && this.id.equals(other.id));
    }

    public String toJsonString() {
        JSONObject value = new JSONObject();
        value.put("shard_id", this.shardId);
        value.put("is_locked", this.isLocked);
        value.put("sort_time", this.sortTime);
        value.put("id", (Object)this.id);
        return value.toString();
    }

    public void fromJsonString(String str) {
        JSONObject value = new JSONObject(str);
        if (value.has("shard_id")) {
            this.shardId = value.getLong("shard_id");
        }
        if (value.has("is_locked")) {
            this.isLocked = value.getBoolean("is_locked");
        }
        if (value.has("sort_time")) {
            this.sortTime = value.getLong("sort_time");
        }
        if (value.has("id")) {
            this.id = value.getString("id");
        }
    }

    public long getShardId() {
        return this.shardId;
    }

    public void setShardId(long shardId) {
        this.shardId = shardId;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getSortTime() {
        return this.sortTime;
    }

    public void setSortTime(long sortTime) {
        this.sortTime = sortTime;
    }
}

