/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.table;

import com.datastax.driver.core.Session;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.cassandra.provider.table.TableHandler;

public class ProcessDefinitionTableHandler
implements TableHandler {
    public static final String TABLE_NAME = "cam_proc_def";
    public static final String TABLE_NAME_IDX_VERSION = "cam_proc_def_idx_version";
    protected static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS cam_proc_def (id text, key text, version int, category text, name text, deployment_id text, suspension_state int, PRIMARY KEY (id));";
    protected static final String CREATE_TABLE_IDX_VERSION = "CREATE TABLE IF NOT EXISTS cam_proc_def_idx_version (key text, version int, id text, PRIMARY KEY (key,version)) WITH CLUSTERING ORDER BY (version DESC);";
    protected static final String DROP_TABLE = "DROP TABLE IF EXISTS cam_proc_def";
    protected static final String DROP_TABLE_IDX_VERSION = "DROP TABLE IF EXISTS cam_proc_def_idx_version";
    protected static final String DEPLOYMENT_ID_IDX = "CREATE INDEX IF NOT EXISTS ON cam_proc_def ( deployment_id );";

    @Override
    public List<String> getTableNames() {
        return Arrays.asList(TABLE_NAME, TABLE_NAME_IDX_VERSION);
    }

    @Override
    public void createTable(Session s) {
        s.execute(CREATE_TABLE);
        s.execute(CREATE_TABLE_IDX_VERSION);
        s.execute(DEPLOYMENT_ID_IDX);
    }

    @Override
    public void dropTable(Session s) {
        s.execute(DROP_TABLE_IDX_VERSION);
        s.execute(DROP_TABLE);
    }
}

