/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.indexes;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.AbstractIndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexUtils;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.util.TypedValueField;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.impl.type.PrimitiveValueTypeImpl;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractVariableValueIndex
extends AbstractIndexHandler<VariableInstanceEntity> {
    private final int LENGTH_LIMIT = 256;

    @Override
    protected String getIndexValue(VariableInstanceEntity entity) {
        return IndexUtils.createIndexValue(entity.getName(), this.getVariableValue(entity));
    }

    private String getVariableValue(VariableInstanceEntity entity) {
        String value = null;
        if (entity.getLongValue() != null) {
            value = entity.getLongValue().toString();
        }
        if (entity.getDoubleValue() != null) {
            value = entity.getDoubleValue().toString();
        }
        if (entity.getTextValue() != null) {
            value = entity.getTextValue();
        }
        if (value == null) {
            return null;
        }
        if (value.length() > 256) {
            value = value.substring(0, 256);
        }
        return value;
    }

    @Override
    protected String getIndexValue(String ... indexValues) {
        if (indexValues.length != 2) {
            throw new IllegalArgumentException("ExecutionIdByVariableValueIndex requires variable name and variable value");
        }
        return IndexUtils.createIndexValue(indexValues);
    }

    public List<String> getValuesByTypedValue(CassandraPersistenceSession cassandraPersistenceSession, String variableName, TypedValue typedValue) {
        TypedValueSerializer serializer = TypedValueField.getSerializers().findSerializerForValue(typedValue);
        if (typedValue instanceof UntypedValueImpl) {
            typedValue = serializer.convertToTypedValue((UntypedValueImpl)typedValue);
        }
        if (typedValue.getType().isPrimitiveValueType() && !(typedValue.getType() instanceof PrimitiveValueTypeImpl.BytesTypeImpl)) {
            VariableInstanceEntity tempEntity = new VariableInstanceEntity();
            serializer.writeValue(typedValue, (ValueFields)tempEntity);
            return this.getValues(null, cassandraPersistenceSession, variableName, this.getVariableValue(tempEntity));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUnique() {
        return false;
    }
}

