/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.indexes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndexUtils {
    public static long calculateShard(long date, long shardSizeMillis) {
        double shardSequenceNumber = Math.floor(date / shardSizeMillis);
        long shardId = (long)(shardSequenceNumber * (double)shardSizeMillis);
        return shardId;
    }

    public static String createIndexValue(String ... indexValues) {
        if (indexValues == null || indexValues.length == 0) {
            throw new IllegalArgumentException("Please supply at least one index value to use an index.");
        }
        if (indexValues.length == 1) {
            return indexValues[0];
        }
        StringBuffer buf = new StringBuffer();
        buf.append(indexValues[0]);
        for (int i = 1; i < indexValues.length; ++i) {
            buf.append("_").append(indexValues[i]);
        }
        return buf.toString();
    }

    public static Set<String> crossCheckIndexes(Set<String> set1, Set<String> set2) {
        ArrayList<Set<String>> list = new ArrayList<Set<String>>(2);
        list.add(set1);
        list.add(set2);
        return IndexUtils.crossCheckIndexes(list);
    }

    public static Set<String> crossCheckIndexes(List<Set<String>> sets) {
        HashSet<String> result = new HashSet<String>();
        if (sets == null || sets.size() == 0) {
            return result;
        }
        if (sets.size() == 1) {
            return sets.get(0);
        }
        int minSize = sets.get(0).size();
        int index = 0;
        for (int i = 1; i < sets.size(); ++i) {
            if (sets.get(i).size() >= minSize) continue;
            minSize = sets.get(i).size();
            index = i;
        }
        for (String key : sets.get(index)) {
            boolean match = true;
            for (int i = 0; i < sets.size() && i != index; ++i) {
                if (sets.get(i).contains(key)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            result.add(key);
        }
        return result;
    }
}

