/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.operation.AbstractEntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;

public class DeploymentOperations
extends AbstractEntityOperationHandler<DeploymentEntity> {
    protected static final String INSERT_STMNT = "INSERT into cam_deployment (id, name, deploy_time) values (?, ?, ?);";

    public DeploymentOperations(CassandraPersistenceSession cassandraPersistenceSession) {
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
    }

    @Override
    public void insert(CassandraPersistenceSession session, DeploymentEntity entity) {
        Session s = session.getSession();
        CassandraSerializer<DeploymentEntity> serializer = CassandraPersistenceSession.getSerializer(DeploymentEntity.class);
        BoundStatement statement = s.prepare(INSERT_STMNT).bind();
        serializer.write((SettableData<?>)statement, entity);
        session.addStatement((Statement)statement);
    }

    @Override
    public void delete(CassandraPersistenceSession session, DeploymentEntity entity) {
        session.addStatement((Statement)QueryBuilder.delete().all().from("cam_deployment").where(QueryBuilder.eq((String)"id", (Object)entity.getId())));
    }

    @Override
    public void update(CassandraPersistenceSession session, DeploymentEntity entity) {
    }

    @Override
    protected Class<DeploymentEntity> getEntityType() {
        return DeploymentEntity.class;
    }

    @Override
    protected String getTableName() {
        return "cam_deployment";
    }
}

