/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.ExecutionIdByProcessIdIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.ProcessIdByBusinessKeyIndex;
import org.camunda.bpm.engine.cassandra.provider.indexes.ProcessIdByExecutionIdIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.EntityOperationHandler;
import org.camunda.bpm.engine.cassandra.provider.operation.LoadedCompositeEntity;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.cassandra.provider.type.UDTypeHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class ExecutionEntityOperations
implements EntityOperationHandler<ExecutionEntity> {
    protected static final String INSERT = "INSERT into cam_proc_inst (id, version, business_key) values (?, ?, ?);";
    protected static Map<Class<?>, IndexHandler<ExecutionEntity>> indexHandlers = new HashMap();

    public ExecutionEntityOperations(CassandraPersistenceSession cassandraPersistenceSession) {
    }

    public static void prepare(CassandraProcessEngineConfiguration config) {
    }

    @Override
    public void insert(CassandraPersistenceSession session, ExecutionEntity entity) {
        Session s = session.getSession();
        if (entity.isProcessInstanceExecution()) {
            session.addStatement((Statement)s.prepare(INSERT).bind(new Object[]{entity.getId(), entity.getRevision(), entity.getBusinessKey()}));
        }
        session.addStatement(this.createUpdateStatement(session, entity));
        for (IndexHandler<ExecutionEntity> index : indexHandlers.values()) {
            session.addStatement(index.getInsertStatement(session, entity));
        }
    }

    @Override
    public void delete(CassandraPersistenceSession session, ExecutionEntity entity) {
        if (entity.isProcessInstanceExecution()) {
            session.addStatement((Statement)QueryBuilder.delete().all().from("cam_proc_inst").where(QueryBuilder.eq((String)"id", (Object)entity.getProcessInstanceId())).onlyIf(QueryBuilder.eq((String)"version", (Object)entity.getRevision())), entity.getProcessInstanceId());
            session.batchShouldNotLock(entity.getProcessInstanceId());
        } else {
            session.addStatement((Statement)QueryBuilder.delete().mapElt("executions", (Object)entity.getId()).from("cam_proc_inst").where(QueryBuilder.eq((String)"id", (Object)entity.getProcessInstanceId())), entity.getProcessInstanceId());
        }
        for (IndexHandler<ExecutionEntity> index : indexHandlers.values()) {
            session.addIndexStatement(index.getDeleteStatement(session, entity), entity.getProcessInstanceId());
        }
    }

    @Override
    public void update(CassandraPersistenceSession session, ExecutionEntity entity) {
        session.addStatement(this.createUpdateStatement(session, entity), entity.getProcessInstanceId());
        for (IndexHandler<ExecutionEntity> index : indexHandlers.values()) {
            session.addIndexStatement(index.getInsertStatement(session, entity), entity.getProcessInstanceId());
        }
    }

    protected Statement createUpdateStatement(CassandraPersistenceSession session, ExecutionEntity entity) {
        Session s = session.getSession();
        UDTypeHandler typeHander = session.getTypeHander(ExecutionEntity.class);
        CassandraSerializer<ExecutionEntity> serializer = CassandraPersistenceSession.getSerializer(ExecutionEntity.class);
        UDTValue value = typeHander.createValue(s);
        serializer.write((SettableData<?>)value, entity);
        return QueryBuilder.update((String)"cam_proc_inst").with(QueryBuilder.put((String)"executions", (Object)entity.getId(), (Object)value)).where(QueryBuilder.eq((String)"id", (Object)entity.getProcessInstanceId()));
    }

    @Override
    public ExecutionEntity getEntityById(CassandraPersistenceSession session, String id) {
        String procId = indexHandlers.get(ProcessIdByExecutionIdIndex.class).getUniqueValue(null, session, id);
        if (procId == null) {
            return null;
        }
        LoadedCompositeEntity loadedCompostite = session.selectCompositeById("process-instance-compostite", procId);
        if (loadedCompostite == null) {
            return null;
        }
        if (procId.equals(id)) {
            return (ExecutionEntity)loadedCompostite.getPrimaryEntity();
        }
        return (ExecutionEntity)loadedCompostite.get("executions").get(id);
    }

    public static IndexHandler<ExecutionEntity> getIndexHandler(Class<?> type) {
        return indexHandlers.get(type);
    }

    static {
        indexHandlers.put(ProcessIdByBusinessKeyIndex.class, new ProcessIdByBusinessKeyIndex());
        indexHandlers.put(ProcessIdByExecutionIdIndex.class, new ProcessIdByExecutionIdIndex());
        indexHandlers.put(ExecutionIdByProcessIdIndex.class, new ExecutionIdByProcessIdIndex());
    }
}

